/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.common;

import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnauthorizedFlowException;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import com.sap.cloud.security.oauth2.flow.service.AuthorizationHeaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidClientCredentials
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(ValidClientCredentials.class);
    private IClientAccessor accessor;
    private AuthorizationHeaderService authorizationService;

    public ValidClientCredentials(IClientAccessor accessor, AuthorizationHeaderService authorizationService) {
        this.accessor = accessor;
        this.authorizationService = authorizationService;
    }

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether client credentials are valid.");
        String authorizationHeader = attributes.getAuthorizationHeader();
        String[] clientIdAndSecret = this.authorizationService.extractUsernameAndPasswordFrom(authorizationHeader);
        if (this.wrongCredentialsAreProvided(clientIdAndSecret[0], clientIdAndSecret[1])) {
            logger.debug("Client secret provided for client [{}] in the credentials does not match.", (Object)clientIdAndSecret[0]);
            throw new UnauthorizedFlowException("Client secret provided for client in the credentials does not match.");
        }
    }

    private boolean wrongCredentialsAreProvided(String clientId, String clientSecret) {
        try {
            return !this.accessor.checkSecret(clientSecret, clientId);
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to verify client credentials.", exception);
        }
    }

    public String toString() {
        return "Valid client credentials";
    }
}

