/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.condition;

import com.sap.cloud.security.oauth2.as.commons.client.BasicClientInfo;
import com.sap.cloud.security.oauth2.as.commons.client.ClientType;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.condition.RequirementCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfidentialClientCondition
implements RequirementCondition {
    private static final Logger logger = LoggerFactory.getLogger(ConfidentialClientCondition.class);
    private IClientAccessor accessor;

    public ConfidentialClientCondition(IClientAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public boolean isFulfilled(RequestAttributes attributes) {
        logger.debug("Checking condition - whether client is confidential.");
        String clientId = attributes.getClientIdFromAuthorizationHeader();
        BasicClientInfo client = this.retreiveClient(clientId);
        if (client == null) {
            return false;
        }
        boolean isConfidentialClient = this.isClientConfidential(client);
        if (!isConfidentialClient) {
            logger.error("Somebody has send authorization header, even though client is public. Client authority: [{}]", (Object)client.getAuthorities());
        }
        return isConfidentialClient;
    }

    private BasicClientInfo retreiveClient(String clientId) {
        try {
            return this.accessor.getBasicClientById(clientId);
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to retreive client by given id.", exception);
        }
    }

    private boolean isClientConfidential(BasicClientInfo client) {
        return client.getClientType() == ClientType.CONFIDENTIAL;
    }

    public String toString() {
        return "Confidential client";
    }
}

