/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.refresh;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.as.commons.token.refreshtoken.IRefreshTokenAccessor;
import com.sap.cloud.security.oauth2.as.commons.token.refreshtoken.RefreshTokenInfo;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshTokenExistence
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(RefreshTokenExistence.class);
    private IRefreshTokenAccessor refreshTokenAccessor;

    public RefreshTokenExistence(IRefreshTokenAccessor refreshTokenAccessor) {
        this.refreshTokenAccessor = refreshTokenAccessor;
    }

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether refresh token exists.");
        String token = attributes.getRefreshToken();
        RefreshTokenInfo refreshToken = this.retrieveRefreshToken(token);
        if (refreshToken == null) {
            throw new UnsatisfiedFlowException("Refresh token is not valid.", ErrorCode.invalid_grant);
        }
    }

    private RefreshTokenInfo retrieveRefreshToken(String token) {
        try {
            return this.refreshTokenAccessor.getToken(token);
        }
        catch (Exception exception) {
            throw new UnexpectedFlowException("Failed to retrieve refresh token.", exception);
        }
    }

    public String toString() {
        return "Existing refresh token";
    }
}

