/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.refresh;

import com.sap.cloud.security.oauth2.as.commons.client.BasicClientInfo;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.as.commons.token.refreshtoken.IRefreshTokenAccessor;
import com.sap.cloud.security.oauth2.as.commons.token.refreshtoken.RefreshTokenInfo;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnauthorizedFlowException;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import com.sap.cloud.security.oauth2.flow.service.ClientIdProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshTokenOwnerMatch
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(RefreshTokenOwnerMatch.class);
    private IRefreshTokenAccessor refreshTokenAccessor;
    private IClientAccessor clientAccessor;
    private ClientIdProvider clientIdProvider;

    public RefreshTokenOwnerMatch(IRefreshTokenAccessor refreshTokenAccessor, IClientAccessor clientAccessor, ClientIdProvider clientIdProvider) {
        this.refreshTokenAccessor = refreshTokenAccessor;
        this.clientAccessor = clientAccessor;
        this.clientIdProvider = clientIdProvider;
    }

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether refresh token is issued for the same client.");
        String tokenId = attributes.getRefreshToken();
        String clientId = this.clientIdProvider.getClientIdFrom(attributes);
        BasicClientInfo client = this.retreiveClient(clientId);
        RefreshTokenInfo token = this.retrieveRefreshToken(tokenId);
        if (this.tokenIsNotIssuedForClient(token, client)) {
            throw new UnauthorizedFlowException("Client credentials do not match the client for which the refresh token is issued.");
        }
    }

    private BasicClientInfo retreiveClient(String clientId) {
        try {
            return this.clientAccessor.getBasicClientById(clientId);
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to retreive client by given id.", exception);
        }
    }

    private RefreshTokenInfo retrieveRefreshToken(String token) {
        try {
            return this.refreshTokenAccessor.getToken(token);
        }
        catch (Exception exception) {
            throw new UnexpectedFlowException("Failed to retrieve refresh token.", exception);
        }
    }

    private boolean tokenIsNotIssuedForClient(RefreshTokenInfo token, BasicClientInfo client) {
        return !token.getClientId().equals(client.getClientId());
    }

    public String toString() {
        return "Refresh token is issued for the same client";
    }
}

