/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.refresh;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshTokenParameterPresence
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(RefreshTokenParameterPresence.class);

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether refresh token is presented in the request.");
        String[] refreshTokenValues = attributes.getRefreshTokenParameters();
        if (refreshTokenValues == null || refreshTokenValues.length == 0) {
            throw new UnsatisfiedFlowException("refresh_token parameter is required field.", ErrorCode.invalid_request);
        }
        if ("".equals(refreshTokenValues[0])) {
            throw new UnsatisfiedFlowException("refresh_token parameter has to be non empty string.", ErrorCode.invalid_request);
        }
        if (refreshTokenValues.length > 1) {
            throw new UnsatisfiedFlowException("refresh_token parameter must be included only once.", ErrorCode.invalid_request);
        }
    }

    public String toString() {
        return "Presence of refresh token";
    }
}

