/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.refresh;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.as.commons.token.refreshtoken.IRefreshTokenAccessor;
import com.sap.cloud.security.oauth2.as.commons.token.refreshtoken.RefreshTokenInfo;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import com.sap.cloud.security.oauth2.flow.requirements.refresh.RefreshTokenExistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshTokenScopesExistence
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(RefreshTokenExistence.class);
    private IRefreshTokenAccessor accessor;

    public RefreshTokenScopesExistence(IRefreshTokenAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether the requested scopes was presented in the previous access token issuing request.");
        String[] requestedScopes = attributes.getScopesAsArray();
        if (requestedScopes != null && requestedScopes.length == 1 && "".equals(requestedScopes[0].trim())) {
            logger.error("Somebody has send scope parameter with empty value, which is not allowed according to OAuth 2.0 specification.");
            return;
        }
        String token = attributes.getRefreshToken();
        RefreshTokenInfo refreshToken = this.retrieveRefreshToken(token);
        if (!refreshToken.containsAllScopes(requestedScopes)) {
            throw new UnsatisfiedFlowException("Not all requested scopes are registered.", ErrorCode.invalid_scope);
        }
    }

    private RefreshTokenInfo retrieveRefreshToken(String token) {
        try {
            return this.accessor.getToken(token);
        }
        catch (Exception exception) {
            throw new UnexpectedFlowException("Failed to retrieve refresh token.", exception);
        }
    }

    public String toString() {
        return "No additional scopes requested";
    }
}

