/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.refresh;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.as.commons.client.BasicClientInfo;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.as.commons.token.refreshtoken.IRefreshTokenAccessor;
import com.sap.cloud.security.oauth2.as.commons.token.refreshtoken.RefreshTokenInfo;
import com.sap.cloud.security.oauth2.as.commons.utils.DateTimeUtils;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import com.sap.cloud.security.oauth2.flow.service.ClientIdProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshTokenValidity
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(RefreshTokenValidity.class);
    private IRefreshTokenAccessor refreshTokenAccessor;
    private IClientAccessor clientAccessor;
    private ClientIdProvider clientIdProvider;

    public RefreshTokenValidity(IRefreshTokenAccessor refreshTokenAccessor, IClientAccessor clientAccessor, ClientIdProvider clientIdProvider) {
        this.refreshTokenAccessor = refreshTokenAccessor;
        this.clientAccessor = clientAccessor;
        this.clientIdProvider = clientIdProvider;
    }

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether refresh token is valid.");
        String token = attributes.getRefreshToken();
        String clientId = this.clientIdProvider.getClientIdFrom(attributes);
        RefreshTokenInfo refreshTokenInfo = this.retrieveRefreshToken(token);
        BasicClientInfo clientInfo = this.retreiveClient(clientId);
        long issuedAt = refreshTokenInfo.getIssuedAt();
        int expiresIn = clientInfo.getRefreshTokenExpiresIn();
        if (DateTimeUtils.isDateExpired(issuedAt, expiresIn)) {
            throw new UnsatisfiedFlowException("Refresh token is expired.", ErrorCode.invalid_grant);
        }
    }

    private RefreshTokenInfo retrieveRefreshToken(String token) {
        try {
            return this.refreshTokenAccessor.getToken(token);
        }
        catch (Exception exception) {
            throw new UnexpectedFlowException("Failed to retrieve refresh token.", exception);
        }
    }

    private BasicClientInfo retreiveClient(String clientId) {
        try {
            return this.clientAccessor.getBasicClientById(clientId);
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to retreive client by given id.", exception);
        }
    }

    public String toString() {
        return "Valid refresh token";
    }
}

