/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.saml;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertionParameterPresence
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(AssertionParameterPresence.class);

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether assertion is presented in the request.");
        String[] assertions = attributes.getAssertionParameters();
        if (assertions == null || assertions.length == 0 || assertions[0] == null) {
            throw new UnsatisfiedFlowException("'assertion' parameter is required field.", ErrorCode.invalid_request);
        }
        if (assertions.length > 1) {
            throw new UnsatisfiedFlowException("'assertion' parameter should be specified only once.", ErrorCode.invalid_request);
        }
        if ("".equals(assertions[0])) {
            throw new UnsatisfiedFlowException("'assertion' parameter has to be non empty string.", ErrorCode.invalid_request);
        }
    }

    public String toString() {
        return "Presence of assertion";
    }
}

