/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.saml;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import com.sap.cloud.security.oauth2.flow.service.SAMLService;
import com.sap.security.saml2.lib.common.SAML2Exception;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidAssertion
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(ValidAssertion.class);
    private SAMLService samlService;

    public ValidAssertion(SAMLService samlService) {
        this.samlService = samlService;
    }

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether assertion is valid.");
        String assertion = attributes.getAssertion();
        try {
            this.samlService.validateAssertion(assertion);
        }
        catch (SAML2Exception e) {
            throw new UnsatisfiedFlowException(e.getMessage(), ErrorCode.invalid_grant);
        }
        catch (LoginException e) {
            throw new UnsatisfiedFlowException(e.getMessage(), ErrorCode.invalid_grant);
        }
    }

    public String toString() {
        return "Valid assertion";
    }
}

