/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.service;

import com.sap.core.jpaas.security.utils.Base64;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationHeaderService {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationHeaderService.class);

    public String[] extractUsernameAndPasswordFrom(String authorizationHeader) {
        if (this.isNotBasicHeader(authorizationHeader)) {
            logger.debug("Authorization header type is not basic. Can not extract user name and password.");
            return null;
        }
        String credentials = this.decodeCredentials(this.extractCredentialsFrom(authorizationHeader));
        return this.parseCredentials(credentials);
    }

    private boolean isNotBasicHeader(String authorizationHeader) {
        return authorizationHeader == null || !authorizationHeader.startsWith("Basic ");
    }

    private String extractCredentialsFrom(String authorizationHeader) {
        return authorizationHeader.substring("Basic ".length());
    }

    private String decodeCredentials(String base64EnodedCredentials) {
        try {
            return new String(Base64.decode((String)base64EnodedCredentials), "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException("Failed to decode basic credentials.", exception);
        }
    }

    private String[] parseCredentials(String credentials) {
        int colonIndex = credentials.indexOf(":");
        if (colonIndex == -1) {
            return null;
        }
        String username = credentials.substring(0, colonIndex);
        String password = credentials.substring(colonIndex + 1);
        return new String[]{username, password};
    }

    public String extractUsernameFrom(String authorizationHeader) {
        String[] usernameAndPassword = this.extractUsernameAndPasswordFrom(authorizationHeader);
        if (usernameAndPassword == null) {
            return null;
        }
        return usernameAndPassword.length == 2 ? usernameAndPassword[0] : null;
    }
}

