/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.service;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.as.commons.saml.SAMLConfigurationAccessor;
import com.sap.cloud.security.oauth2.flow.exceptions.UnauthorizedFlowException;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.security.saml2.cfg.interfaces.SAML2SPConfiguration;
import com.sap.security.saml2.commons.SAML2Principal;
import com.sap.security.saml2.lib.common.SAML2DataFactory;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.sp.sso.SAML2Authentication;
import com.sap.security.saml2.sp.sso.ValidationResult;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLService {
    private static final Logger logger = LoggerFactory.getLogger(SAMLService.class);
    private ValidationResult validationResult;
    private SAMLConfigurationAccessor samlConfigurationAccessor;

    public SAMLService(SAMLConfigurationAccessor samlConfigurationAccessor) {
        this.samlConfigurationAccessor = samlConfigurationAccessor;
    }

    public void validateAssertion(String assertion) throws LoginException, SAML2Exception {
        String decodedAssertion = this.fromBase64(assertion);
        SAML2Assertion saml2Assertion = this.createAssertion(decodedAssertion);
        logger.debug("Validating received SAML assertion.");
        this.validationResult = this.validateAssertion(saml2Assertion);
        logger.debug("SAML assertion was successfully validated.");
    }

    String fromBase64(String assertion) throws SAML2Exception {
        return SAML2Utils.decodeBase64AsString((String)assertion);
    }

    SAML2Assertion createAssertion(String decodedAssertion) throws SAML2Exception {
        return SAML2DataFactory.getInstance().createSAML2Assertion(decodedAssertion);
    }

    ValidationResult validateAssertion(SAML2Assertion saml2Assertion) throws LoginException {
        try {
            return SAML2Authentication.getInstance().validateAssertion((SAML2SPConfiguration)this.samlConfigurationAccessor.getSAML2Config(), saml2Assertion, saml2Assertion.getIssuer().getName());
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to read SAML configuration.", exception);
        }
    }

    public SAML2Principal resolveUserPrincipal(String assertion) {
        if (this.validationResult == null) {
            try {
                this.validateAssertion(assertion);
            }
            catch (LoginException exception) {
                logger.error("Failed to validate assertion.", (Throwable)exception);
                throw new UnauthorizedFlowException("Failed to validate assertion.");
            }
            catch (SAML2Exception exception) {
                logger.error("Provided assertion has invalid format.", (Throwable)exception);
                throw new UnsatisfiedFlowException("Invalid assertion provided.", ErrorCode.invalid_request);
            }
        }
        return this.validationResult.getPrincipal();
    }
}

