/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HanaWebSocket;
import com.sap.db.jdbc.LatencySession;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.util.MessageTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.security.cert.X509Certificate;

@NotThreadSafe
public class BasicSession
extends Session {
    static final SessionFactory BASIC_SESSION_FACTORY = new SessionFactory(){

        @Override
        public Session newInstance(ConnectionSapDB connection, Address address) throws RTEException {
            return connection.getConnectionProperties().hasProperty(ConnectionProperty.LATENCY) ? new LatencySession(connection, address) : new BasicSession(connection, address);
        }
    };
    @GuardedBy(value="_connection (implicit)")
    private final Socket _socket;
    @GuardedBy(value="_connection (implicit)")
    private final HanaWebSocket _webSocket;
    @GuardedBy(value="_connection (implicit)")
    private final InputStream _inputStream;
    @GuardedBy(value="_connection (implicit)")
    private final OutputStream _outputStream;

    BasicSession(ConnectionSapDB connection, Address address) throws RTEException {
        super(connection, address);
        HanaWebSocket[] webSocketOutputParm = new HanaWebSocket[1];
        try {
            this._socket = this._openSocket(null, webSocketOutputParm);
            this._webSocket = webSocketOutputParm[0];
            this._inputStream = this._socket.getInputStream();
            this._outputStream = this._socket.getOutputStream();
        }
        catch (IOException e) {
            this.destroy();
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", address.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
    }

    @Override
    protected Socket _getSocket() {
        return this._socket;
    }

    @Override
    protected HanaWebSocket _getWebSocket() {
        return this._webSocket;
    }

    @Override
    protected void _sendBytes(byte[] buffer, int len) throws RTEException {
        this._writeBytes(buffer, len);
    }

    @Override
    protected int _receiveBytes(byte[] buffer, int off, int len) throws RTEException {
        return this._readBytes(buffer, off, len);
    }

    @Override
    protected void _writeBytes(byte[] buffer, int len) throws RTEException {
        this._writeSocket(this._outputStream, buffer, len);
    }

    @Override
    protected int _readBytes(byte[] buffer, int off, int len) throws RTEException {
        return this._readSocket(this._inputStream, buffer, off, len);
    }

    @Override
    protected X509Certificate[] _getPeerCertificateChain() {
        return null;
    }
}

