/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.PublicAddress;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SiteTypeVolumeID;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.SystemInfo;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.trace.Tracer;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public class SessionPool {
    private final WeakReference<ConnectionSapDB> _connection;
    private final Tracer _tracer;
    private final Map<SiteTypeVolumeID, Session> _sessions;
    private final AtomicReference<Session> _anchorSession;
    private final AtomicReference<Session> _primarySession;
    private final AtomicReference<SystemInfo> _systemInfo;
    private final AtomicReference<Session> _lastExecutedSession;
    private final AtomicInteger _lastAnchorConnectionID;

    public SessionPool(ConnectionSapDB connection) {
        this._connection = new WeakReference<ConnectionSapDB>(connection);
        this._tracer = connection.getTracer();
        this._sessions = new ConcurrentHashMap<SiteTypeVolumeID, Session>();
        this._anchorSession = new AtomicReference();
        this._primarySession = new AtomicReference();
        this._systemInfo = new AtomicReference();
        this._lastExecutedSession = new AtomicReference();
        this._lastAnchorConnectionID = new AtomicInteger();
    }

    public Map<SiteTypeVolumeID, Session> getSessions() {
        return Collections.unmodifiableMap(this._sessions);
    }

    public Session getSession(SiteTypeVolumeID siteTypeVolumeID) {
        SystemInfo systemInfo = this._systemInfo.get();
        if (systemInfo == null) {
            return null;
        }
        Session session = this._sessions.get(siteTypeVolumeID);
        if (session == null) {
            int siteCount = systemInfo.getSiteCount();
            int volumeID = siteTypeVolumeID.getVolumeID();
            if (siteCount == 1) {
                for (SiteTypeVolumeID aSiteTypeVolumeID : this._sessions.keySet()) {
                    if (aSiteTypeVolumeID.getVolumeID() != volumeID) continue;
                    return this._sessions.get(aSiteTypeVolumeID);
                }
            }
        }
        return session;
    }

    public Session getAnchorSession() {
        return this._anchorSession.get();
    }

    public Session getPrimarySession() {
        return this._primarySession.get();
    }

    public void setPrimarySession(Session session) {
        Session primarySession = this._primarySession.get();
        if (primarySession == null) {
            this._primarySession.set(session);
            if (this._tracer.on()) {
                this._tracer.printDistribution((ConnectionSapDB)this._connection.get(), "Primary session changed to " + session.getTraceString(true, false));
            }
        } else if (primarySession != session) {
            this._primarySession.set(session);
            if (!session.isHintRouted()) {
                this.setSendSessionContextFlag();
            }
            if (this._tracer.on()) {
                this._tracer.printDistribution((ConnectionSapDB)this._connection.get(), "Primary session changed to " + session.getTraceString(true, false));
            }
        }
    }

    public SystemInfo getSystemInfo() {
        return this._systemInfo.get();
    }

    public void setSystemInfo(SystemInfo systemInfo) {
        this._systemInfo.set(systemInfo);
    }

    public Session getLastExecutedSession() {
        return this._lastExecutedSession.get();
    }

    public void setLastExecutedSession(Session session) {
        this._lastExecutedSession.set(session);
    }

    public int getLastAnchorConnectionID() {
        Integer lastAnchorConnectionID = this._lastAnchorConnectionID.get();
        return lastAnchorConnectionID != null ? lastAnchorConnectionID : -1;
    }

    public void addSession(Session session) {
        SystemInfo systemInfo;
        SiteVolumeID siteVolumeID = session.getSiteVolumeID();
        Session primarySession = this._primarySession.get();
        if (!session.isHintRouted()) {
            if (this._anchorSession.compareAndSet(null, session)) {
                this._lastAnchorConnectionID.set(session.getConnectionID());
                if (this._tracer.on()) {
                    this._tracer.printDistribution((ConnectionSapDB)this._connection.get(), "Anchor session changed to " + session.getTraceString(true, false));
                }
            }
            if (primarySession == null || !primarySession.isConnected()) {
                this._primarySession.set(session);
                if (this._tracer.on()) {
                    this._tracer.printDistribution((ConnectionSapDB)this._connection.get(), "Primary session changed to " + session.getTraceString(true, false));
                }
            } else if (primarySession.getSiteVolumeID().equals(siteVolumeID)) {
                this._primarySession.set(session);
                if (this._tracer.on()) {
                    this._tracer.printDistribution((ConnectionSapDB)this._connection.get(), "Primary session changed to " + session.getTraceString(true, false));
                }
            }
        }
        SiteType siteType = (systemInfo = this._systemInfo.get()) != null ? systemInfo.getSiteType(siteVolumeID.getSiteID()) : SiteType.NONE;
        this._sessions.put(new SiteTypeVolumeID(siteType, siteVolumeID.getVolumeID()), session);
    }

    public void removeSession(ConnectionSapDB connection, SiteTypeVolumeID siteTypeVolumeID) throws SQLException {
        Session session = this._sessions.get(siteTypeVolumeID);
        if (session == null || !session.isConnected()) {
            this._sessions.remove(siteTypeVolumeID);
            return;
        }
        if (connection != null) {
            try {
                HRequestPacket requestPacket = connection.initDisconnect(session);
                connection.exchange(session, requestPacket, null, new ConnectionSapDB.ExchangeFlag[0]);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._sessions.remove(siteTypeVolumeID);
        }
        session.destroy();
    }

    public void setSendSessionContextFlag() {
        for (Session session : this.getSessions().values()) {
            session.setSendSessionContextFlag();
        }
    }

    public void setSendSessionVariablesFlag() {
        for (Session session : this.getSessions().values()) {
            session.setSendSessionVariablesFlag();
        }
    }

    public void setSendClientInfoFlag() {
        for (Session session : this.getSessions().values()) {
            session.setSendClientInfoFlag();
        }
    }

    public void releaseAll(ConnectionSapDB connection) {
        this._releaseSessions(connection, false);
        this._sessions.clear();
        this._anchorSession.set(null);
        this._systemInfo.set(null);
        this._lastExecutedSession.set(null);
    }

    public void releaseAllHintRouted(ConnectionSapDB connection) {
        this._releaseSessions(connection, true);
    }

    protected void _setSessionPublicAddress(Session session, PublicAddress publicAddress) {
        session._address.set(publicAddress);
        for (Map.Entry<SiteTypeVolumeID, Session> entry : this._sessions.entrySet()) {
            SiteTypeVolumeID siteTypeVolumeID = entry.getKey();
            Session aSession = entry.getValue();
            if (aSession != session) continue;
            if (siteTypeVolumeID.getSiteType() == publicAddress.getSiteType()) break;
            this._sessions.remove(siteTypeVolumeID);
            this._sessions.put(new SiteTypeVolumeID(publicAddress.getSiteType(), publicAddress.getSiteVolumeID().getVolumeID()), session);
            break;
        }
    }

    private void _releaseSessions(ConnectionSapDB connection, boolean hintRoutedOnly) {
        HashSet<SiteTypeVolumeID> siteTypeVolumeIDSet = new HashSet<SiteTypeVolumeID>(this._sessions.keySet());
        for (SiteTypeVolumeID siteTypeVolumeID : siteTypeVolumeIDSet) {
            Session session = this._sessions.get(siteTypeVolumeID);
            if (session == null || !session.isConnected()) {
                this._sessions.remove(siteTypeVolumeID);
                continue;
            }
            if (hintRoutedOnly && !session.isHintRouted()) continue;
            try {
                this.removeSession(connection, siteTypeVolumeID);
            }
            catch (SQLException sQLException) {}
        }
    }

    public Map<SiteTypeVolumeID, Session> getSessionsMap() {
        return this._sessions;
    }

    public int getNumberOfLocations() {
        SystemInfo systemInfo = this._systemInfo.get();
        return systemInfo != null ? systemInfo.getAddressCount() : -1;
    }
}

