/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.SavepointSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.TransactionState;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.HexUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

@NotThreadSafe
public class Transaction {
    private final ConnectionSapDB _connection;
    private final Tracer _tracer;
    private final SessionPool _sessionPool;
    private final Map<String, SavepointSapDB> _savepointMap;
    private boolean _autoCommit;
    private boolean _ddlAutoCommit;
    private TransactionState _transactionState;
    private int _numberOfSessionsInvolved;
    private byte[] _transactionID;

    Transaction(ConnectionSapDB connection) {
        this._connection = connection;
        this._tracer = connection.getTracer();
        this._sessionPool = connection.getSessionPool();
        this._savepointMap = new HashMap<String, SavepointSapDB>();
        this._autoCommit = true;
        this._ddlAutoCommit = true;
        this._transactionState = TransactionState.None;
    }

    boolean getAutoCommit() {
        return this._autoCommit;
    }

    void setAutoCommit(boolean autoCommit) {
        if (!this._autoCommit && autoCommit && !this._ddlAutoCommit) {
            this._ddlAutoCommit = true;
        }
        this._autoCommit = autoCommit;
    }

    boolean getDDLAutoCommit() {
        return this._ddlAutoCommit;
    }

    void setDDLAutoCommit(boolean ddlAutoCommit) {
        this._ddlAutoCommit = ddlAutoCommit;
    }

    TransactionState getTransactionState() {
        return this._transactionState;
    }

    boolean isWriteTransaction() {
        return this._transactionState == TransactionState.WriteTransaction || this._transactionState == TransactionState.DistributedTransaction;
    }

    void setTransactionState(Session session, TransactionState newState) {
        if (this._transactionState == newState) {
            return;
        }
        if (!this._checkSession(session)) {
            return;
        }
        if (this._transactionState == TransactionState.None && (newState == TransactionState.ReadTransaction || newState == TransactionState.WriteTransaction) || this._transactionState == TransactionState.ReadTransaction && newState == TransactionState.WriteTransaction) {
            this._sessionPool.setPrimarySession(session);
        }
        this._transactionState = newState;
        if (this._tracer.on()) {
            this._tracer.printDistribution(this._connection, "Change Tx " + this.getDisplayTransactionID() + " state to " + this._transactionState.name() + " on session " + session.getTraceString(true, false));
        }
    }

    TransactionState getNewTransactionState(Session session, FunctionCode functionCode) {
        TransactionState newState;
        if (!this._checkSession(session)) {
            return null;
        }
        switch (functionCode) {
            case Commit: 
            case Rollback: 
            case Connect: 
            case Disconnect: {
                newState = TransactionState.None;
                break;
            }
            case XAStart: 
            case XAJoin: 
            case Nil: 
            case CloseCursor: 
            case DDL: {
                newState = null;
                break;
            }
            default: {
                newState = TransactionState.ReadTransaction;
            }
        }
        return newState;
    }

    void handleTransaction(ConnectionSapDB connection, Session session, boolean allowChangePrimaryAndXAJoin) throws SQLException {
        if (session.isHintRouted()) {
            return;
        }
        this.addSessionToTransaction(session);
        if (!allowChangePrimaryAndXAJoin) {
            return;
        }
        switch (this._transactionState) {
            case None: {
                this._sessionPool.setPrimarySession(session);
                break;
            }
            case ReadTransaction: {
                break;
            }
            case WriteTransaction: {
                if (this._numberOfSessionsInvolved <= 1) break;
                this._startDistributedTransaction(connection);
                this._joinDistributedTransaction(connection, session);
                break;
            }
            case DistributedTransaction: {
                if (session.isPartOfDistributedTransaction()) break;
                this._joinDistributedTransaction(connection, session);
                break;
            }
        }
    }

    void addSessionToTransaction(Session session) {
        if (session.isPartOfTransaction()) {
            return;
        }
        session.joinTransaction();
        ++this._numberOfSessionsInvolved;
    }

    SavepointSapDB getSavepoint(String name) {
        return this._savepointMap.get(name);
    }

    void setSavepoint(SavepointSapDB savepoint) {
        this._savepointMap.put(savepoint._getName(), savepoint);
    }

    void clearTransaction(ConnectionSapDB connection, boolean forCloseOrReconnect) {
        String primaryConnectionPreference;
        this._savepointMap.clear();
        if (this._transactionState == TransactionState.None && this._numberOfSessionsInvolved == 0 && this._transactionID == null) {
            return;
        }
        this._transactionState = TransactionState.None;
        for (Session session : this._sessionPool.getSessions().values()) {
            session.leaveTransaction();
        }
        if (this._tracer.on() && this._transactionState != TransactionState.Unknown) {
            this._tracer.printDistributionState(connection, "Close Tx " + this.getDisplayTransactionID());
        }
        this._numberOfSessionsInvolved = 0;
        this._transactionID = null;
        if (!forCloseOrReconnect && !(primaryConnectionPreference = connection.getConnectionProperty(ConnectionProperty.PRIMARY_CONNECTION)).equalsIgnoreCase("LASTPRIMARY")) {
            Session lastExecutedSession;
            if (primaryConnectionPreference.equalsIgnoreCase("LASTEXECUTE") && (lastExecutedSession = this._sessionPool.getLastExecutedSession()) != null) {
                this._sessionPool.setPrimarySession(lastExecutedSession);
            } else {
                Session anchorSession = this._sessionPool.getAnchorSession();
                if (anchorSession != null) {
                    this._sessionPool.setPrimarySession(anchorSession);
                }
            }
        }
    }

    String getDisplayTransactionID() {
        return "[" + HexUtils.toHexString(this._transactionID) + "]";
    }

    private boolean _checkSession(Session session) {
        Session anchorSession = this._sessionPool.getAnchorSession();
        return anchorSession == null || !anchorSession.isNoneOrPrimarySite() || !session.isSecondarySite();
    }

    private void _startDistributedTransaction(ConnectionSapDB connection) throws SQLException {
        if (this._transactionState == TransactionState.DistributedTransaction) {
            return;
        }
        Session session = this._sessionPool.getPrimarySession();
        HRequestPacket requestPacket = connection.initStartDistributedTransaction(session);
        HReplyPacket replyPacket = connection.exchange(session, requestPacket, null, new ConnectionSapDB.ExchangeFlag[0]);
        this._transactionID = replyPacket.findTransactionID(0, this._transactionID);
        this._transactionState = TransactionState.DistributedTransaction;
        session.joinDistributedTransaction();
        if (this._tracer.on()) {
            this._tracer.printDistribution(this._connection, "Start Distributed Tx " + this.getDisplayTransactionID() + " on session " + session.getTraceString(true, false));
        }
    }

    private void _joinDistributedTransaction(ConnectionSapDB connection, Session session) throws SQLException {
        if (session.isPartOfDistributedTransaction()) {
            return;
        }
        HRequestPacket requestPacket = connection.initJoinDistributedTransaction(session, this._transactionID);
        connection.exchange(session, requestPacket, null, new ConnectionSapDB.ExchangeFlag[0]);
        session.joinDistributedTransaction();
        if (this._tracer.on()) {
            this._tracer.printDistribution(this._connection, "Join Distributed Tx " + this.getDisplayTransactionID() + " on session " + session.getTraceString(true, false));
        }
    }

    int getSavepointCount() {
        return this._savepointMap.size();
    }
}

