/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.ach.manager.impl;

import com.sap.js.ach.manager.impl.ACHConfig;
import com.sap.js.ach.manager.impl.ACHIndexer;
import com.sap.js.ach.manager.impl.BaseACHInfo;
import java.net.URL;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class ACHBundleInfo
extends BaseACHInfo {
    private static final long serialVersionUID = 1L;

    ACHBundleInfo() {
    }

    void removePreviouslyUninstalledBundles(BundleContext ctx) {
        for (ACHConfig ach : this.achConfigurations.values()) {
            Bundle b = ctx.getBundle(ach.getBundleId());
            if (b != null) continue;
            this.removeBundle(ach.getBundleId());
        }
    }

    void read3rdPartyBundleConfiguration(Bundle[] configBundles) {
        Bundle[] bundleArray = configBundles;
        int n = configBundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            String files = (String)bundle.getHeaders().get("Bundle-ACH-ComponentFiles");
            this.parse3rdPartyBundleACHFiles(files, configBundles[0]);
            ++n2;
        }
    }

    @Override
    protected String getInfo(Object object) {
        if (object instanceof Bundle) {
            Bundle bundle = (Bundle)object;
            return String.valueOf(bundle.getSymbolicName()) + "(" + bundle.getBundleId() + ")";
        }
        return null;
    }

    @Override
    protected URL getResource(Object object, String resource) {
        if (object instanceof Bundle) {
            Bundle bundle = (Bundle)object;
            return bundle.getResource(resource);
        }
        return null;
    }

    @Override
    protected void indexBundle(String bundleSymbolicName, String ach) {
        ACHIndexer.indexBundle(bundleSymbolicName, ach, this);
    }
}

