/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.ach.manager.impl;

import com.sap.js.ach.manager.ACHManager;
import com.sap.js.ach.manager.impl.ACHConfig;
import com.sap.js.ach.manager.impl.BaseACHInfo;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class ACHCommandProvider
implements CommandProvider {
    private ACHManager achManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void _listach(CommandInterpreter ci) {
        ci.println((Object)"Packages Configured by Bundle ACH Configuration");
        ci.println((Object)"-----------------------------------------------");
        ci.print((Object)this.achManager.getACHBundleInfo().toString());
        ci.println();
        ci.println((Object)"Package Configured by Package ACH Configuration");
        ci.println((Object)"-----------------------------------------------");
        ci.print((Object)this.achManager.getACHPackageStore().toString());
        ci.println();
        ci.println((Object)"Bundle Configuration");
        ci.println((Object)"--------------------");
        BaseACHInfo baseACHInfo = this.achManager.getACHBundleInfo();
        synchronized (baseACHInfo) {
            ConcurrentHashMap<String, ACHConfig> cfgs = this.achManager.getACHBundleInfo().getACHConfigurations();
            for (ACHConfig ach : cfgs.values()) {
                ci.print((Object)(String.valueOf(ach.getBundleName()) + " -> " + ach.getAchComponent()));
                if (ach.getConfigType() == ACHConfig.ConfigType.BUNDLE_CONFIGURED) {
                    ci.println((Object)" (BUNDLE CONFIGURED)");
                    continue;
                }
                ci.println((Object)" (CONFIG FILE)");
            }
        }
    }

    public synchronized void _getach(CommandInterpreter ci) {
        String name = ci.nextArgument();
        if (name != null) {
            ci.println((Object)this.getList(this.achManager.getACHComponents(name)));
        } else {
            ci.println((Object)"The argument is null. Write logger name as command argument.");
        }
    }

    public String getHelp() {
        return "---LJS ACH Components---" + System.getProperty("line.separator") + "\tlistach - list ACH Components" + System.getProperty("line.separator") + "\tgetach <logger name> - return ACH component of <logger>" + System.getProperty("line.separator");
    }

    String getList(String[] achs) {
        if (achs == null || achs.length == 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("[");
        String[] stringArray = achs;
        int n = achs.length;
        int n2 = 0;
        while (n2 < n) {
            String ach = stringArray[n2];
            b.append(ach).append(",");
            ++n2;
        }
        b.deleteCharAt(b.length() - 1);
        b.append("]");
        return b.toString();
    }

    protected void addAchManager(ACHManager achManager) {
        this.achManager = achManager;
    }

    protected void removeAchManager(ACHManager achManager) {
        this.achManager = null;
    }
}

