/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.ach.manager.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

public class ACHConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String achComponent;
    private final Set<String> packages;
    private final long bundleId;
    private final long bundleUpdate;
    private final ConfigType configType;
    private final String bundleSymbolicName;

    String getBundleName() {
        return this.bundleSymbolicName;
    }

    public ACHConfig(String ach, Set<String> packages, long id, long bundleUpdate, String bundleName, ConfigType configType) {
        if (ach == null) {
            ach = "";
        }
        this.configType = configType;
        this.achComponent = ach;
        this.packages = Collections.unmodifiableSet(packages);
        this.bundleId = id;
        this.bundleUpdate = bundleUpdate;
        this.bundleSymbolicName = bundleName;
    }

    String getAchComponent() {
        return this.achComponent;
    }

    void setAchComponent(String ach) {
        this.achComponent = ach;
    }

    Set<String> getPackages() {
        return this.packages;
    }

    ConfigType getConfigType() {
        return this.configType;
    }

    long getBundleId() {
        return this.bundleId;
    }

    long getBundleUpdate() {
        return this.bundleUpdate;
    }

    public int hashCode() {
        return this.achComponent.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ACHConfig)) {
            return false;
        }
        ACHConfig ach = (ACHConfig)o;
        return this.bundleSymbolicName == ach.bundleSymbolicName;
    }

    public static enum ConfigType {
        BUNDLE_CONFIGURED,
        BUNDLE_THRIRD_PARTY;

    }
}

