/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.ach.manager.impl;

import com.sap.js.ach.manager.impl.ACHBundleInfo;
import com.sap.js.ach.manager.impl.ACHConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarInputStream;
import org.apache.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

class ACHIndexer {
    private static final Logger logger = Logger.getLogger(ACHIndexer.class);
    private static final String EXTERNAL_PREFIX = "external:";
    private static final BundleContext ctx = FrameworkUtil.getBundle(ACHIndexer.class).getBundleContext();

    ACHIndexer() {
    }

    static void indexBundlesOnBundleStartup(BundleContext ctx, ACHBundleInfo info) {
        List<Bundle> newBundles = ACHIndexer.getBundlesChangedAfter(ctx, info.getLastUpdate());
        if (newBundles.size() == 0) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found " + newBundles.size() + " new bundles to check and index for ACH info."));
        }
        long after = info.getLastUpdate();
        for (Bundle cand : newBundles) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Updating bundle " + cand.getSymbolicName() + " modified: " + new Date(cand.getLastModified()).toString() + " after " + new Date(after).toString()));
            }
            info.removeBundle(cand.getBundleId());
            ACHIndexer.indexBundle(cand, info);
        }
        info.removePreviouslyUninstalledBundles(ctx);
    }

    static boolean indexBundle(Bundle b, ACHBundleInfo info) {
        String ach = (String)b.getHeaders().get("SAP-ACH-Component");
        info.setLastUpdate(b.getLastModified());
        if (ach == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No ACH component configured for Bundle " + b.getBundleId() + "."));
            }
            return false;
        }
        ACHConfig masterACHConfig = new ACHConfig(ach, ACHIndexer.getBundlePackages(b), b.getBundleId(), b.getLastModified(), b.getSymbolicName(), ACHConfig.ConfigType.BUNDLE_CONFIGURED);
        info.installBundle(masterACHConfig);
        return true;
    }

    static boolean indexBundle(String bundleSymbolicName, String ach, ACHBundleInfo info) {
        Bundle[] candidates = ctx.getBundles();
        Bundle toIndex = null;
        Bundle[] bundleArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle cand = bundleArray[n2];
            if (bundleSymbolicName.equals(cand.getSymbolicName())) {
                toIndex = cand;
                break;
            }
            ++n2;
        }
        if (toIndex == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Configured ACH Component " + ach + " for bundle " + bundleSymbolicName + " but bundle is not installed."));
            }
            return false;
        }
        ACHConfig masterACHConfig = new ACHConfig(ach, ACHIndexer.getBundlePackages(toIndex), toIndex.getBundleId(), toIndex.getLastModified(), toIndex.getSymbolicName(), ACHConfig.ConfigType.BUNDLE_THRIRD_PARTY);
        info.installBundle(masterACHConfig);
        return true;
    }

    private static List<Bundle> getBundlesChangedAfter(BundleContext ctx, long after) {
        ArrayList<Bundle> bl = new ArrayList<Bundle>();
        Bundle[] bundleArray = ctx.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (b.getLastModified() > after) {
                bl.add(b);
            }
            ++n2;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private static Set<String> getBundlePackages(Bundle b) {
        packages = new HashSet<String>();
        var5_2 = ACHIndexer.getBundleClasspath(b);
        var4_3 = var5_2.length;
        var3_4 = 0;
        while (var3_4 < var4_3) {
            block24: {
                block28: {
                    block25: {
                        block23: {
                            cpath = var5_2[var3_4];
                            if (!cpath.endsWith(".jar")) break block28;
                            jis = null;
                            jarFileName = null;
                            if (!cpath.startsWith("external:")) ** GOTO lbl29
                            jarNameCandidate = ACHIndexer.getExternalJarName(cpath);
                            f = new File(jarNameCandidate);
                            if (f.exists()) break block23;
                            if (ACHIndexer.logger.isDebugEnabled()) {
                                ACHIndexer.logger.debug((Object)("File " + cpath + " in bundle classpath does not exist."));
                            }
                            if (jis == null) ** GOTO lbl90
                            try {
                                jis.close();
                            }
                            catch (IOException e) {
                                if (!ACHIndexer.logger.isDebugEnabled()) break block24;
                                ACHIndexer.logger.debug((Object)"Cannot close the stream.", (Throwable)e);
                            }
                            break block24;
                        }
                        jis = new JarInputStream(new FileInputStream(f));
                        ** GOTO lbl45
lbl29:
                        // 1 sources

                        jarFileName = b.getEntry(cpath);
                        if (jarFileName != null) break block25;
                        if (ACHIndexer.logger.isDebugEnabled()) {
                            ACHIndexer.logger.debug((Object)("Invalid Bundle-Classpath in bundle " + b.getBundleId()));
                        }
                        if (jis == null) break block24;
                        try {
                            jis.close();
                        }
                        catch (IOException e) {
                            if (!ACHIndexer.logger.isDebugEnabled()) break block24;
                            ACHIndexer.logger.debug((Object)"Cannot close the stream.", (Throwable)e);
                        }
                        break block24;
                    }
                    try {
                        try {
                            jis = new JarInputStream(jarFileName.openStream());
lbl45:
                            // 2 sources

                            entry = null;
                            while ((entry = jis.getNextEntry()) != null) {
                                if (!entry.getName().endsWith(".class")) continue;
                                packages.add(ACHIndexer.getPackageFromClassFilename(entry.getName()));
                            }
                        }
                        catch (IOException v0) {
                            if (ACHIndexer.logger.isDebugEnabled()) {
                                ACHIndexer.logger.debug((Object)("Unable to check bundle classpath of bundle " + b.getBundleId()));
                            }
                            if (jis == null) ** GOTO lbl90
                            try {
                                jis.close();
                            }
                            catch (IOException e) {
                                if (!ACHIndexer.logger.isDebugEnabled()) ** GOTO lbl90
                                ACHIndexer.logger.debug((Object)"Cannot close the stream.", (Throwable)e);
                            }
                        }
                    }
                    catch (Throwable var10_16) {
                        block27: {
                            if (jis != null) {
                                try {
                                    jis.close();
                                }
                                catch (IOException e) {
                                    if (!ACHIndexer.logger.isDebugEnabled()) break block27;
                                    ACHIndexer.logger.debug((Object)"Cannot close the stream.", (Throwable)e);
                                }
                            }
                        }
                        throw var10_16;
                    }
                    if (jis == null) break block24;
                    try {
                        jis.close();
                    }
                    catch (IOException e) {
                        if (!ACHIndexer.logger.isDebugEnabled()) break block24;
                        ACHIndexer.logger.debug((Object)"Cannot close the stream.", (Throwable)e);
                    }
                    break block24;
                }
                searchPath = cpath.equals(".") != false ? "/" : cpath;
                entries = b.findEntries(searchPath, "*.class", true);
                while (entries != null && entries.hasMoreElements()) {
                    classFile = (URL)entries.nextElement();
                    packages.add(ACHIndexer.getPackageFromClassFilename(classFile.getPath()));
                }
            }
            ++var3_4;
        }
        return packages;
    }

    private static String getPackageFromClassFilename(String classFilename) {
        if (classFilename.startsWith("/")) {
            classFilename = classFilename.substring(1);
        }
        if (classFilename.startsWith("WEB-INF/classes/")) {
            classFilename = classFilename.substring(16);
        }
        if (classFilename.contains("/")) {
            classFilename = classFilename.substring(0, classFilename.lastIndexOf(47));
        }
        return classFilename.replace('/', '.');
    }

    private static String[] getBundleClasspath(Bundle b) {
        String classpath = (String)b.getHeaders().get("Bundle-Classpath");
        if (classpath == null) {
            return new String[]{"."};
        }
        StringTokenizer tok = new StringTokenizer(classpath, ",");
        String[] paths = new String[tok.countTokens()];
        int i = 0;
        while (i < paths.length) {
            paths[i] = tok.nextToken();
            ++i;
        }
        return paths;
    }

    private static String getExternalJarName(String cpath) {
        String path = cpath.substring(EXTERNAL_PREFIX.length());
        StringBuilder computedPath = new StringBuilder();
        boolean inVariable = false;
        StringBuilder variable = null;
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            if (!inVariable) {
                if (c == '$') {
                    variable = new StringBuilder();
                    inVariable = true;
                } else {
                    computedPath.append(c);
                }
            } else if (c != '$') {
                variable.append(c);
            } else {
                String cand = variable.toString();
                String value = null;
                if (!"".equals(cand)) {
                    value = System.getProperty(variable.toString());
                }
                if (value != null) {
                    computedPath.append(value);
                } else {
                    computedPath.append("$").append((CharSequence)variable).append("$");
                }
                inVariable = false;
            }
            ++i;
        }
        if (inVariable) {
            computedPath.append("$").append((CharSequence)variable);
        }
        return computedPath.toString();
    }
}

