/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.ach.manager.impl;

import com.sap.js.ach.manager.impl.ACHBundleInfo;
import com.sap.js.ach.manager.impl.ACHIndexer;
import com.sap.js.ach.manager.impl.ACHPackageStore;
import com.sap.js.ach.manager.impl.BaseACHInfo;
import com.sap.js.ach.manager.impl.BaseACHManager;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;

public class ACHManagerImpl
extends BaseACHManager
implements BundleListener {
    private BundleContext bundleContext;

    protected final void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
        this.info = BaseACHInfo.readACHInfo(this.bundleContext.getDataFile(""));
        if (this.info == null) {
            this.info = new ACHBundleInfo();
        }
        Bundle[] achConfigBundles = ACHManagerImpl.getThridPartyConfigurationFragments(this.bundleContext);
        ((ACHBundleInfo)this.info).read3rdPartyBundleConfiguration(achConfigBundles);
        ACHIndexer.indexBundlesOnBundleStartup(this.bundleContext, (ACHBundleInfo)this.info);
        this.info.resyncThirdPartyConfiguration();
        BaseACHInfo.storeACHInfo(this.bundleContext.getDataFile(""), this.info);
        this.pkgStore = new ACHPackageStore(achConfigBundles);
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    protected final void deactivate(ComponentContext componentContext) {
    }

    private void clearRuntimeStore() {
        this.runtimeStore.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent arg0) {
        switch (arg0.getType()) {
            case 1: {
                BaseACHInfo baseACHInfo = this.info;
                synchronized (baseACHInfo) {
                    ACHIndexer.indexBundle(arg0.getBundle(), (ACHBundleInfo)this.info);
                    BaseACHInfo.storeACHInfo(this.bundleContext.getDataFile(""), this.info);
                    this.clearRuntimeStore();
                    break;
                }
            }
            case 16: {
                BaseACHInfo baseACHInfo = this.info;
                synchronized (baseACHInfo) {
                    ((ACHBundleInfo)this.info).removeBundle(arg0.getBundle().getBundleId());
                    BaseACHInfo.storeACHInfo(this.bundleContext.getDataFile(""), this.info);
                    this.clearRuntimeStore();
                    break;
                }
            }
            case 8: {
                BaseACHInfo baseACHInfo = this.info;
                synchronized (baseACHInfo) {
                    ((ACHBundleInfo)this.info).removeBundle(arg0.getBundle().getBundleId());
                    ACHIndexer.indexBundle(arg0.getBundle(), (ACHBundleInfo)this.info);
                    BaseACHInfo.storeACHInfo(this.bundleContext.getDataFile(""), this.info);
                    this.clearRuntimeStore();
                    break;
                }
            }
        }
    }

    static Bundle[] getThridPartyConfigurationFragments(BundleContext ctx) {
        BundleWiring bundleWiring;
        Bundle bundle = ctx.getBundle();
        ArrayList<Bundle> fragments = new ArrayList<Bundle>();
        fragments.add(bundle);
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (bundleRevision != null && (bundleWiring = bundleRevision.getWiring()) != null) {
            List bundleWires = bundleWiring.getProvidedWires("osgi.wiring.host");
            int i = 0;
            while (bundleWires != null && i < bundleWires.size()) {
                fragments.add(((BundleWire)bundleWires.get(i)).getRequirerWiring().getRevision().getBundle());
                ++i;
            }
        }
        return fragments.toArray(new Bundle[fragments.size()]);
    }
}

