/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.ach.manager.impl;

import com.sap.js.ach.manager.impl.ACHConfig;
import com.sap.js.ach.manager.impl.ArchiveResourceLoader;
import com.sap.js.ach.manager.impl.PropertiesUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public abstract class BaseACHInfo
extends ArchiveResourceLoader {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(BaseACHInfo.class);
    private long lastUpdated = 0L;
    private final ConcurrentHashMap<String, Set<ACHConfig>> packageMapping = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, ACHConfig> achConfigurations = new ConcurrentHashMap();
    private transient HashMap<String, String> thirdPartyACHMapping = new HashMap();
    private boolean dirty = true;

    private void addPackage(String pkg, ACHConfig masterConfig) {
        Set<ACHConfig> achs = this.packageMapping.get(pkg);
        if (achs == null) {
            achs = new HashSet<ACHConfig>();
            achs.add(masterConfig);
            this.packageMapping.put(pkg, achs);
        } else {
            boolean found = false;
            for (ACHConfig ach : achs) {
                if (!ach.equals(masterConfig)) continue;
                found = true;
                break;
            }
            if (!found) {
                achs.add(masterConfig);
                this.packageMapping.put(pkg, achs);
            }
        }
    }

    private void removePackage(String pkg, ACHConfig masterConfig) {
        Set<ACHConfig> achs = this.packageMapping.get(pkg);
        if (achs == null) {
            return;
        }
        achs.remove(masterConfig);
        if (achs.size() == 0) {
            this.packageMapping.remove(pkg);
        } else {
            this.packageMapping.put(pkg, achs);
        }
    }

    Set<String> getACHComponent(String pkg) {
        return this.getACHStrings(this.packageMapping.get(pkg));
    }

    private Set<String> getACHStrings(Set<ACHConfig> cfgs) {
        if (cfgs == null) {
            return new HashSet<String>();
        }
        HashSet<String> comps = new HashSet<String>();
        for (ACHConfig c : cfgs) {
            comps.add(c.getAchComponent());
        }
        return comps;
    }

    long getLastUpdate() {
        return this.lastUpdated;
    }

    void setLastUpdate(long time) {
        if (this.lastUpdated < time) {
            this.lastUpdated = time;
        }
    }

    private void writeToStream(OutputStream out) throws IOException {
        ObjectOutputStream os = new ObjectOutputStream(out);
        os.writeObject(this);
    }

    private static BaseACHInfo readFromStream(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(in);
        return (BaseACHInfo)ois.readObject();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        TreeSet<String> ts = new TreeSet<String>();
        for (String pkg : this.packageMapping.keySet()) {
            ts.add(pkg);
        }
        for (String pkg : ts) {
            Set<ACHConfig> acs = this.packageMapping.get(pkg);
            Set<String> strs = this.getACHStrings(acs);
            b.append(String.valueOf(pkg) + " -> [");
            for (String ach : strs) {
                b.append(ach);
                b.append(",");
            }
            b.deleteCharAt(b.length() - 1);
            b.append("]").append(System.getProperty("line.separator"));
        }
        return b.toString();
    }

    protected void parse3rdPartyBundleACHFiles(String files, Object object) {
        String[] fileArray;
        if (files == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("3rd party ACH bundle info configured inside the following file: " + this.getInfo(object)));
        }
        if (this.thirdPartyACHMapping == null) {
            this.thirdPartyACHMapping = new HashMap();
        }
        String[] stringArray = fileArray = files.split(",");
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            Properties prop = PropertiesUtils.loadProperties(this, object, filename.trim());
            if (prop != null) {
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    this.cacheACHMappings(((String)entry.getKey()).trim(), ((String)entry.getValue()).trim());
                }
            }
            ++n2;
        }
    }

    private void cacheACHMappings(String ach, String bundlesString) {
        String[] bundles;
        String[] stringArray = bundles = bundlesString.split(",");
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            String bsn = stringArray[n2];
            if (bsn != null && !(bsn = bsn.trim()).equals("")) {
                this.thirdPartyACHMapping.put(bsn, ach);
            }
            ++n2;
        }
    }

    public static void storeACHInfo(File base, BaseACHInfo info) {
        block22: {
            File storeAs;
            if (!info.dirty) {
                return;
            }
            info.dirty = false;
            if (base == null) {
                return;
            }
            File f1 = new File(base, "ACHInfo.1");
            File f2 = new File(base, "ACHInfo.2");
            if (f1.exists() && f2.exists()) {
                File renamed;
                String newName;
                if (f1.lastModified() > f2.lastModified()) {
                    newName = f2.getName();
                    f2.delete();
                    storeAs = new File(base, f1.getName());
                    renamed = new File(base, newName);
                    f1.renameTo(renamed);
                } else {
                    newName = f1.getName();
                    f1.delete();
                    storeAs = new File(base, f2.getName());
                    renamed = new File(base, newName);
                    f2.renameTo(renamed);
                }
            } else {
                storeAs = f1.exists() && !f2.exists() ? new File(base, "ACHInfo.2") : (!f1.exists() && f2.exists() ? new File(base, "ACHInfo.1") : new File(base, "ACHInfo.1"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Storing ACH Configuration due to a system update in " + storeAs.getName()));
            }
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(storeAs);
                    info.writeToStream(fos);
                }
                catch (IOException iOException) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Unable to write ACH info file: " + storeAs.getName()));
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        break block22;
                    }
                    catch (IOException iOException2) {}
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Unable to fully structure code
     */
    public static BaseACHInfo readACHInfo(File base) {
        info = null;
        f1 = new File(base, "ACHInfo.1");
        f2 = new File(base, "ACHInfo.2");
        achFile = new File[2];
        if (f1.exists() && f2.exists()) {
            if (f1.lastModified() > f2.lastModified()) {
                achFile[0] = f1;
                achFile[1] = f2;
            } else {
                achFile[0] = f2;
                achFile[1] = f1;
            }
        } else if (f1.exists() && !f2.exists()) {
            achFile[0] = f1;
        } else if (!f1.exists() && f2.exists()) {
            achFile[0] = f2;
        }
        var8_5 = achFile;
        var7_6 = achFile.length;
        var6_7 = 0;
        while (var6_7 < var7_6) {
            f = var8_5[var6_7];
            if (f != null) {
                fis = null;
                fis = new FileInputStream(f);
                info = BaseACHInfo.readFromStream(fis);
                if (fis == null) break;
                try {
                    fis.close();
                }
                catch (IOException v0) {}
                break;
                catch (IOException io) {
                    BaseACHInfo.logger.error((Object)("Unable to read ACH info file: " + f.getName()), (Throwable)io);
                    ** if (fis == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        try {
                            fis.close();
                        }
                        catch (IOException v1) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (ClassNotFoundException cn) {
                    BaseACHInfo.logger.error((Object)("Unable to read ACH info file: " + f.getName()), (Throwable)cn);
                    ** if (fis == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        try {
                            fis.close();
                        }
                        catch (IOException v2) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    {
                        catch (Throwable var11_13) {
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException v3) {}
                            }
                            throw var11_13;
                        }
                    }
                }
            }
            ++var6_7;
        }
        return info;
    }

    ConcurrentHashMap<String, ACHConfig> getACHConfigurations() {
        return this.achConfigurations;
    }

    ConcurrentHashMap<String, Set<ACHConfig>> getPackageMapping() {
        return this.packageMapping;
    }

    public synchronized void installBundle(ACHConfig masterConfig) {
        this.dirty = true;
        this.achConfigurations.put(masterConfig.getBundleName(), masterConfig);
        for (String pkg : masterConfig.getPackages()) {
            this.addPackage(pkg, masterConfig);
        }
        this.addPackage(masterConfig.getBundleName(), masterConfig);
        this.setLastUpdate(masterConfig.getBundleUpdate());
    }

    synchronized void removeBundle(long bundleId) {
        this.setLastUpdate(System.currentTimeMillis());
        this.dirty = true;
        ACHConfig bundleAchConfig = null;
        for (ACHConfig c : this.achConfigurations.values()) {
            if (c.getBundleId() != bundleId) continue;
            bundleAchConfig = c;
            break;
        }
        if (bundleAchConfig == null) {
            return;
        }
        this.achConfigurations.remove(bundleAchConfig.getBundleName());
        for (String pkg : bundleAchConfig.getPackages()) {
            this.removePackage(pkg, bundleAchConfig);
        }
        this.removePackage(bundleAchConfig.getBundleName(), bundleAchConfig);
        this.setLastUpdate(System.currentTimeMillis());
    }

    public void resyncThirdPartyConfiguration() {
        if (this.thirdPartyACHMapping == null) {
            this.thirdPartyACHMapping = new HashMap();
        }
        for (String bundleSymbolicName : this.thirdPartyACHMapping.keySet()) {
            String ach = this.thirdPartyACHMapping.get(bundleSymbolicName);
            ACHConfig achConf = this.achConfigurations.get(bundleSymbolicName);
            if (achConf == null) {
                this.indexBundle(bundleSymbolicName, ach);
                continue;
            }
            if (achConf.getAchComponent().equals(ach)) continue;
            if (achConf.getConfigType() == ACHConfig.ConfigType.BUNDLE_CONFIGURED) {
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)("Bundle " + achConf.getBundleName() + " is configured for ACH Component " + achConf.getAchComponent() + " which takes precedence over " + ach));
                continue;
            }
            achConf.setAchComponent(ach);
        }
        for (ACHConfig conf : this.achConfigurations.values()) {
            if (conf.getConfigType() != ACHConfig.ConfigType.BUNDLE_THRIRD_PARTY || this.thirdPartyACHMapping.containsKey(conf.getBundleName())) continue;
            this.removeBundle(conf.getBundleId());
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("Removed ACH mapping for bundle " + conf.getBundleName() + " because 3rd party configuration was removed"));
        }
    }

    protected abstract void indexBundle(String var1, String var2);
}

