/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.ach.manager.impl;

import com.sap.js.ach.manager.ACHManager;
import com.sap.js.ach.manager.impl.ACHConfig;
import com.sap.js.ach.manager.impl.BaseACHInfo;
import com.sap.js.ach.manager.impl.BaseACHPackageStore;
import com.sap.js.ach.manager.impl.ComponentCache;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BaseACHManager
implements ACHManager {
    protected BaseACHInfo info;
    protected BaseACHPackageStore pkgStore;
    protected final ComponentCache runtimeStore = new ComponentCache(1000);
    private final ComponentCache bundleNamesStore = new ComponentCache(1000);

    @Override
    public String[] getACHComponents(String loggerName) {
        Set<String> cached = this.runtimeStore.get(loggerName);
        if (cached != null) {
            return cached.toArray(new String[cached.size()]);
        }
        HashSet<String> ach = new HashSet<String>();
        Set<String> viaBundle = this.info.getACHComponent(loggerName);
        Set<String> viaPackages = this.pkgStore.getACH(loggerName);
        if (viaBundle != null) {
            ach.addAll(viaBundle);
        }
        if (viaPackages != null) {
            ach.addAll(viaPackages);
        }
        if (ach.size() > 0) {
            this.runtimeStore.put(loggerName, ach);
            return ach.toArray(new String[ach.size()]);
        }
        int last = loggerName.lastIndexOf(".");
        if (last > 0) {
            String shortenedLoggerName = loggerName.substring(0, last);
            viaBundle = this.info.getACHComponent(shortenedLoggerName);
        }
        if (viaBundle == null) {
            viaBundle = new HashSet<String>();
        }
        this.runtimeStore.put(loggerName, viaBundle);
        return viaBundle.toArray(new String[viaBundle.size()]);
    }

    @Override
    public String[] getBundleNames(String loggerName) {
        String shortenedLoggerName;
        int last;
        Set<String> cached = this.bundleNamesStore.get(loggerName);
        if (cached != null) {
            return cached.toArray(new String[cached.size()]);
        }
        ConcurrentHashMap<String, Set<ACHConfig>> config = this.info.getPackageMapping();
        Set<ACHConfig> cfgs = config.get(loggerName);
        if (cfgs == null && (last = loggerName.lastIndexOf(".")) > 0 && (cfgs = config.get(shortenedLoggerName = loggerName.substring(0, last))) != null) {
            HashSet<String> names = new HashSet<String>();
            for (ACHConfig ach : cfgs) {
                names.add(ach.getBundleName());
            }
            this.bundleNamesStore.put(loggerName, names);
            return names.toArray(new String[names.size()]);
        }
        return new String[0];
    }

    @Override
    public BaseACHInfo getACHBundleInfo() {
        return this.info;
    }

    @Override
    public BaseACHPackageStore getACHPackageStore() {
        return this.pkgStore;
    }
}

