/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.ach.manager.impl;

import com.sap.js.ach.manager.impl.ArchiveResourceLoader;
import com.sap.js.ach.manager.impl.PropertiesUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class BaseACHPackageStore
extends ArchiveResourceLoader
implements Serializable {
    private static final Logger logger = Logger.getLogger(BaseACHPackageStore.class);
    private final Map<String, Set<String>> definitionStore = new HashMap<String, Set<String>>();
    private static final long serialVersionUID = 5816840846988122970L;

    protected void parsePackageACHFiles(String files, Object object, Map<String, Set<String>> mapping) {
        String[] fileArray;
        if (files == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found bundle with ACH package info: " + this.getInfo(object)));
        }
        String[] stringArray = fileArray = files.split(",");
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            Properties prop = PropertiesUtils.loadProperties(this, object, filename.trim());
            if (prop != null) {
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    this.cacheACHMappings(((String)entry.getKey()).trim(), ((String)entry.getValue()).trim(), mapping);
                }
            }
            ++n2;
        }
    }

    private void cacheACHMappings(String ach, String packagesString, Map<String, Set<String>> mapping) {
        String[] packages = packagesString.split(",");
        HashSet<String> packageList = new HashSet<String>();
        String[] stringArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String bsn = stringArray[n2];
            if (bsn != null && !(bsn = bsn.trim()).equals("")) {
                packageList.add(bsn);
            }
            ++n2;
        }
        if (packageList.size() > 0) {
            mapping.put(ach, packageList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getACH(String packageName) {
        Set<String> match = null;
        Map<String, Set<String>> map = this.definitionStore;
        synchronized (map) {
            match = this.findMatch(this.definitionStore, packageName);
        }
        if (match != null && match.size() > 0) {
            return match;
        }
        return null;
    }

    private Set<String> findMatch(Map<String, Set<String>> definitionStore, String packageName) {
        Set<String> found = null;
        found = definitionStore.get(packageName);
        if (found != null) {
            return found;
        }
        String[] splitPackages = packageName.split("\\.");
        int i = 1;
        while (i < splitPackages.length) {
            String shortenedPath = this.shortenPath(splitPackages, i);
            found = definitionStore.get(shortenedPath);
            if (found != null) {
                return found;
            }
            ++i;
        }
        return null;
    }

    private String shortenPath(String[] splitPackages, int numSegmentsToCutOff) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < splitPackages.length - numSegmentsToCutOff) {
            if (i != 0) {
                buf.append('.');
            }
            buf.append(splitPackages[i]);
            ++i;
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addACH(String ach, String packagename) {
        Map<String, Set<String>> map = this.definitionStore;
        synchronized (map) {
            Set<String> components4package = this.definitionStore.get(packagename);
            if (components4package == null) {
                components4package = new HashSet<String>();
            }
            components4package.add(ach);
            this.definitionStore.put(packagename, components4package);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (String pkg : this.definitionStore.keySet()) {
            Set<String> achs = this.definitionStore.get(pkg);
            for (String ach : achs) {
                result.append(pkg).append(".* -> ").append(ach);
                result.append(System.getProperty("line.separator"));
            }
        }
        return result.toString();
    }

    protected void initAllACHDef(Map<String, Set<String>> achDefMap) {
        for (String ach : achDefMap.keySet()) {
            for (String packagename : achDefMap.get(ach)) {
                this.addACH(ach, packagename);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("added ach " + ach + " for package " + packagename));
            }
        }
    }
}

