/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.ach.manager.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class ComponentCache {
    private LinkedHashMap<String, Set<String>> map;
    private int cacheSize;
    private static final float loadFactor = 0.75f;

    ComponentCache(int cacheSize) {
        this.cacheSize = cacheSize;
        int capacity = (int)Math.ceil((float)cacheSize / 0.75f) + 1;
        this.map = new LinkedHashMap<String, Set<String>>(capacity, 0.75f, true){
            private static final long serialVersionUID = -964187312954394583L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Set<String>> eldest) {
                return this.size() > ComponentCache.this.cacheSize;
            }
        };
    }

    synchronized void put(String location, Set<String> components) {
        if (location != null && components != null) {
            this.map.put(location, components);
        }
    }

    synchronized Set<String> get(String location) {
        return this.map.get(location);
    }

    synchronized void clear() {
        this.map.clear();
    }
}

