/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.ach.manager.impl;

import com.sap.js.ach.manager.impl.ArchiveResourceLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;

class PropertiesUtils {
    private static final Logger logger = Logger.getLogger(PropertiesUtils.class);

    private PropertiesUtils() {
    }

    static Properties loadProperties(ArchiveResourceLoader resourceLoader, Object object, String filename) {
        Properties prop = null;
        InputStream is = null;
        try {
            URL url = resourceLoader.getResource(object, filename);
            if (url == null) {
                logger.error((Object)("could not find properties file: " + filename));
                return null;
            }
            try {
                is = url.openStream();
                if (is != null) {
                    prop = new Properties();
                    prop.load(is);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.error((Object)("ACH package file not found: " + filename + " in " + resourceLoader.getInfo(object)));
            }
            catch (IOException e) {
                logger.error((Object)("exception while reading ACH package file: " + filename), (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)("exception while reading ACH package file: " + filename), (Throwable)e);
            }
        }
        finally {
            block26: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block26;
                        logger.debug((Object)("Cannot close the stream for ACH package file: " + filename), (Throwable)e);
                    }
                }
            }
        }
        return prop;
    }
}

