/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.ach.manager.tomcat;

import com.sap.js.ach.manager.impl.ACHConfig;
import com.sap.js.ach.manager.tomcat.ACHJarInfo;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

class ACHJarIndexer {
    private static Logger logger = Logger.getLogger(ACHJarIndexer.class);

    ACHJarIndexer() {
    }

    static void indexJar(Attributes attrs, JarFile jarFile, ACHJarInfo info) {
        String ach = attrs.getValue("SAP-ACH-Component");
        if (ach == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No ACH component configured for " + jarFile.getName() + "."));
            }
            return;
        }
        ACHConfig masterACHConfig = new ACHConfig(ach, ACHJarIndexer.getPackages(jarFile), 0L, 0L, ACHJarIndexer.getJarName(jarFile.getName()), ACHConfig.ConfigType.BUNDLE_CONFIGURED);
        info.installBundle(masterACHConfig);
    }

    static void indexJar(String bundleSymbolicName, String ach, ACHJarInfo info) {
        Set<URL> candidates = info.getCachedJarURLs(bundleSymbolicName);
        if (candidates == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Configured ACH Component " + ach + " for jar " + bundleSymbolicName + " but jar is not installed."));
            }
            return;
        }
        for (URL candidate : candidates) {
            ZipFile jarFile = null;
            try {
                try {
                    JarURLConnection jarURLConn = (JarURLConnection)candidate.openConnection();
                    jarFile = jarURLConn.getJarFile();
                    ACHConfig masterACHConfig = new ACHConfig(ach, ACHJarIndexer.getPackages((JarFile)jarFile), 0L, 0L, ACHJarIndexer.getJarName(jarFile.getName()), ACHConfig.ConfigType.BUNDLE_THRIRD_PARTY);
                    info.installBundle(masterACHConfig);
                }
                catch (IOException e) {
                    logger.error((Object)("Exception occurred while scanning " + candidate), (Throwable)e);
                    if (jarFile == null) continue;
                    try {
                        jarFile.close();
                    }
                    catch (IOException e2) {
                        logger.error((Object)("Exception occurred while closing jar file " + candidate), (Throwable)e2);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)("Exception occurred while closing jar file " + candidate), (Throwable)e);
                    }
                }
                throw throwable;
            }
            if (jarFile == null) continue;
            try {
                jarFile.close();
            }
            catch (IOException e) {
                logger.error((Object)("Exception occurred while closing jar file " + candidate), (Throwable)e);
            }
        }
    }

    private static Set<String> getPackages(JarFile jarFile) {
        HashSet<String> packages = new HashSet<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries != null && entries.hasMoreElements()) {
            JarEntry classFile = entries.nextElement();
            if (!classFile.getName().endsWith(".class") || classFile.isDirectory()) continue;
            packages.add(ACHJarIndexer.getPackageFromClassFilename(classFile.getName()));
        }
        return packages;
    }

    private static String getPackageFromClassFilename(String classFilename) {
        if (classFilename.startsWith("/")) {
            classFilename = classFilename.substring(1);
        }
        if (classFilename.startsWith("WEB-INF/classes/")) {
            classFilename = classFilename.substring(16);
        }
        if (classFilename.contains("/")) {
            classFilename = classFilename.substring(0, classFilename.lastIndexOf(47));
        }
        return classFilename.replace('/', '.');
    }

    static String getJarName(String fullJarName) {
        int index = (fullJarName = fullJarName.replace('\\', '/')).lastIndexOf(47);
        if (index == -1) {
            return fullJarName.substring(0, fullJarName.length() - 4);
        }
        return fullJarName.substring(index + 1, fullJarName.length() - 4);
    }
}

