/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.ach.manager.tomcat;

import com.sap.js.ach.manager.impl.BaseACHInfo;
import com.sap.js.ach.manager.tomcat.ACHJarIndexer;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import org.apache.log4j.Logger;

class ACHJarInfo
extends BaseACHInfo {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ACHJarInfo.class);
    private Map<String, Set<URL>> cachedJarURLs = new HashMap<String, Set<URL>>();

    ACHJarInfo() {
    }

    void read3rdPartyBundleConfiguration(Attributes attrs, JarURLConnection jarURLConn) throws IOException {
        this.cacheJarURLs(jarURLConn);
        String files = attrs.getValue("Bundle-ACH-ComponentFiles");
        this.parse3rdPartyBundleACHFiles(files, jarURLConn);
    }

    private void cacheJarURLs(JarURLConnection jarURLConn) throws IOException {
        URL jarURL = jarURLConn.getURL();
        String jarName = ACHJarIndexer.getJarName(jarURLConn.getJarFile().getName());
        this.addToJarURLsCache(jarName, jarURL);
    }

    private void addToJarURLsCache(String jarName, URL jarURL) {
        Set<URL> conns;
        if (this.cachedJarURLs == null) {
            this.cachedJarURLs = new HashMap<String, Set<URL>>();
        }
        if ((conns = this.cachedJarURLs.get(jarName)) == null) {
            conns = new HashSet<URL>();
        }
        conns.add(jarURL);
        this.cachedJarURLs.put(jarName, conns);
    }

    Set<URL> getCachedJarURLs(String jarName) {
        return this.cachedJarURLs.get(jarName);
    }

    @Override
    protected String getInfo(Object object) {
        if (object instanceof JarURLConnection) {
            JarURLConnection jarFileURLConn = (JarURLConnection)object;
            return jarFileURLConn.toString();
        }
        return null;
    }

    @Override
    protected URL getResource(Object object, String resource) {
        block4: {
            if (object instanceof JarURLConnection) {
                JarURLConnection jarFileURLConn = (JarURLConnection)object;
                try {
                    if (jarFileURLConn.getJarFile().getJarEntry(resource) != null) {
                        return new URL("jar:" + jarFileURLConn.getJarFileURL() + "!/" + resource);
                    }
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)("Cannot construct URL." + e));
                }
            }
        }
        return null;
    }

    @Override
    protected void indexBundle(String bundleSymbolicName, String ach) {
        ACHJarIndexer.indexJar(bundleSymbolicName, ach, this);
    }
}

