/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.ach.manager.tomcat;

import com.sap.js.ach.manager.impl.BaseACHPackageStore;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import java.util.jar.Attributes;
import org.apache.log4j.Logger;

class ACHJarPackageStore
extends BaseACHPackageStore {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ACHJarPackageStore.class);

    ACHJarPackageStore() {
    }

    void init(Attributes attrs, JarURLConnection jarURLConn) throws IOException {
        String files = attrs.getValue("Package-ACH-ComponentFiles");
        HashMap<String, Set<String>> achDefMap = new HashMap<String, Set<String>>();
        this.parsePackageACHFiles(files, jarURLConn, achDefMap);
        this.initAllACHDef(achDefMap);
    }

    @Override
    protected String getInfo(Object object) {
        if (object instanceof JarURLConnection) {
            JarURLConnection jarFileURLConn = (JarURLConnection)object;
            return jarFileURLConn.toString();
        }
        return null;
    }

    @Override
    protected URL getResource(Object object, String resource) {
        block4: {
            if (object instanceof JarURLConnection) {
                JarURLConnection jarFileURLConn = (JarURLConnection)object;
                try {
                    if (jarFileURLConn.getJarFile().getJarEntry(resource) != null) {
                        return new URL("jar:" + jarFileURLConn.getJarFileURL() + "!/" + resource);
                    }
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)("Cannot construct URL." + e));
                }
            }
        }
        return null;
    }
}

