/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.ach.manager.tomcat;

import com.sap.js.ach.manager.ACHManager;
import com.sap.js.ach.manager.impl.BaseACHInfo;
import com.sap.js.ach.manager.impl.BaseACHManager;
import com.sap.js.ach.manager.tomcat.ACHJarIndexer;
import com.sap.js.ach.manager.tomcat.ACHJarInfo;
import com.sap.js.ach.manager.tomcat.ACHJarPackageStore;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;

public class TomcatACHManagerImpl
extends BaseACHManager {
    private static final Logger logger = Logger.getLogger(TomcatACHManagerImpl.class);
    static final String WORK_FOLDER = "work";
    private static final String IMPL_FOLDER = "impl";
    static final String CATALINA_BASE_SYS_PROP = "catalina.base";
    static final String JAR_EXTENSION = ".jar";
    private static final String FILE_PREFIX_COM_SAP = "com.sap";
    static final String JAR_URL_SCHEME = "jar:";
    static final String FILE_URL_SCHEME = "file:";
    static final String JAR_TO_ENTRY_SEPARATOR = "!/";
    private static final ACHManager INSTANCE = new TomcatACHManagerImpl();

    private TomcatACHManagerImpl() {
        String catalinaBase = System.getProperty(CATALINA_BASE_SYS_PROP, ".");
        this.info = BaseACHInfo.readACHInfo(new File(catalinaBase, WORK_FOLDER));
        if (this.info == null) {
            this.info = new ACHJarInfo();
        }
        this.pkgStore = new ACHJarPackageStore();
        this.scanClassloader();
        this.scanDirectory(new File(catalinaBase, IMPL_FOLDER));
        this.info.resyncThirdPartyConfiguration();
        BaseACHInfo.storeACHInfo(new File(catalinaBase, WORK_FOLDER), this.info);
    }

    public static ACHManager getInstance() {
        return INSTANCE;
    }

    private void scanClassloader() {
        ClassLoader loader = this.getClass().getClassLoader();
        while (loader != null) {
            if (loader instanceof URLClassLoader) {
                URL[] urls;
                URL[] uRLArray = urls = ((URLClassLoader)loader).getURLs();
                int n = urls.length;
                int n2 = 0;
                while (n2 < n) {
                    URL url = uRLArray[n2];
                    try {
                        URLConnection conn = url.openConnection();
                        if (conn instanceof JarURLConnection) {
                            this.process((JarURLConnection)conn);
                        } else {
                            String urlStr = url.toString();
                            if (urlStr.startsWith(FILE_URL_SCHEME) && urlStr.endsWith(JAR_EXTENSION)) {
                                URL jarURL = new URL(JAR_URL_SCHEME + urlStr + JAR_TO_ENTRY_SEPARATOR);
                                this.process((JarURLConnection)jarURL.openConnection());
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)("Exception occurred while scanning " + url), (Throwable)e);
                    }
                    ++n2;
                }
            }
            loader = loader.getParent();
        }
    }

    private void scanDirectory(File directory) {
        File[] files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().startsWith(TomcatACHManagerImpl.FILE_PREFIX_COM_SAP) && pathname.getName().endsWith(TomcatACHManagerImpl.JAR_EXTENSION);
            }
        });
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    URL jarURL = new URL(JAR_URL_SCHEME + file.toURI().toString() + JAR_TO_ENTRY_SEPARATOR);
                    this.process((JarURLConnection)jarURL.openConnection());
                }
                catch (IOException e) {
                    logger.error((Object)("Exception occurred while scanning " + file), (Throwable)e);
                }
                ++n2;
            }
        }
    }

    private void process(JarURLConnection jarURLConn) throws IOException {
        JarFile jarFile = null;
        try {
            jarFile = jarURLConn.getJarFile();
            Manifest manifest = jarFile.getManifest();
            Attributes attrs = manifest.getMainAttributes();
            ((ACHJarInfo)this.info).read3rdPartyBundleConfiguration(attrs, jarURLConn);
            ((ACHJarPackageStore)this.pkgStore).init(attrs, jarURLConn);
            ACHJarIndexer.indexJar(attrs, jarFile, (ACHJarInfo)this.info);
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }
}

