/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service;

import com.sap.core.jpaas.security.saml2.service.SAML2BearerAssertionData;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2ConfigurationJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.accessor.ConfigurationAccessor;
import com.sap.core.jpaas.security.saml2.service.cfg.accessor.ConfigurationAccessorFactory;
import com.sap.core.tenant.api.Tenant;
import com.sap.security.saml2.cfg.custom.SAML2LocalIdPCustomImpl;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.lib.common.SAML2DataFactory;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2IDGenerator;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Attribute;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2AttributeStatement;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2AuthnStatement;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SubjectConfirmation;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SubjectConfirmationData;
import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.UnsupportedUserAttributeException;
import com.sap.security.um.user.User;
import com.sap.security.um.user.UserProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2BearerGenerationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAML2BearerGenerationService.class);
    private static SAML2BearerGenerationService instance;
    private static ThreadLocal<Integer> threadLocal;

    static {
        threadLocal = new ThreadLocal();
    }

    SAML2BearerGenerationService() {
    }

    public static synchronized SAML2BearerGenerationService getInstance() {
        if (instance == null) {
            instance = new SAML2BearerGenerationService();
        }
        return instance;
    }

    public static void setSkipRoleResolution(boolean skipRoleResolution) {
        if (skipRoleResolution) {
            threadLocal.set(1);
        } else {
            threadLocal.remove();
        }
    }

    public String generateBearerAsserion(SAML2BearerAssertionData data) throws SAML2Exception, SAML2ConfigurationException {
        LOGGER.debug("Will generate assertion based on incoming data: {}", (Object)data);
        ConfigurationAccessor configurationAccessor = this.getConfigurationAccessor();
        SAML2ConfigurationJPaaSImpl idpConfiguration = configurationAccessor.getConfiguration();
        SAML2LocalIdPCustomImpl idpConfig = idpConfiguration.getLocalIdP();
        if (idpConfig == null) {
            throw new SAML2ConfigurationException("Can't retrieve the local IDP SAML2 configuration.");
        }
        String idpName = idpConfig.getName();
        if (data.getAssertionIssuer() != null && !data.getAssertionIssuer().isEmpty()) {
            idpName = data.getAssertionIssuer();
        }
        SAML2DataFactory saml2DataFactory = SAML2DataFactory.getInstance();
        SAML2AuthnStatement authnStatement = saml2DataFactory.createSAML2AuthnStatement(new Date(System.currentTimeMillis()));
        authnStatement.setAuthnContextClassRef(data.getAuthnContextClassRef());
        authnStatement.setSessionIndex(data.getSessionIndex());
        if (data.getSessionNotOnOrAfter() != -1L) {
            authnStatement.setSessionNotOnOrAfter(new Date(data.getSessionNotOnOrAfter()));
        }
        List<SAML2AuthnStatement> authnStatements = Collections.singletonList(authnStatement);
        SAML2NameID idpNameID = saml2DataFactory.createSAML2NameID(idpName);
        String assertionid = SAML2IDGenerator.generateAssertionID();
        SAML2Assertion assertion = saml2DataFactory.createSAML2Assertion(assertionid, new Date(System.currentTimeMillis()), idpNameID, authnStatements);
        User user = this.getUser();
        SAML2NameID subjectNameId = this.createSaml2NameId(data, user);
        assertion.setSubjectNameID(subjectNameId);
        List<SAML2SubjectConfirmation> confirmations = this.createSubjectConfirmations(data, (SAML2LocalIdP)idpConfig);
        assertion.setSubjectConfirmations(confirmations);
        assertion.setConditionsAudienceRestriction(Collections.singletonList(data.getAudience()));
        Date dateNotBefore = new Date(System.currentTimeMillis() - (long)idpConfig.getAssertionValidityNotBeforeInMinutes() * 60L * 1000L);
        assertion.setConditionsNotBefore(dateNotBefore);
        Date dateNotOrAfter = new Date(System.currentTimeMillis() + (long)idpConfig.getAssertionValidityNotAfterInMinutes() * 60L * 1000L);
        assertion.setConditionsNotOnOrAfter(dateNotOrAfter);
        SAML2AttributeStatement attributeStatement = this.createSAML2AttributeStatements(data, user);
        assertion.setAttributeStatements(Collections.singletonList(attributeStatement));
        assertion.sign(idpConfig.getPrivateKeyForSignature());
        String result = assertion.generate();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Generated assertion {}", (Object)assertion.getXMLRepresentation());
        }
        return result;
    }

    ConfigurationAccessor getConfigurationAccessor() {
        return ConfigurationAccessorFactory.createApplicationConfigurationAccessor();
    }

    String getSystemProperty(String propertyName) {
        return System.getenv(propertyName);
    }

    User getUser() throws SAML2Exception {
        User user = null;
        try {
            UserProvider userProvider = UserManagementAccessor.getUserProvider();
            if (userProvider == null) {
                throw new SAML2Exception("Cannot generate OAuth 2.0 SAML Bearer Assertion because there is no user provider found.");
            }
            user = userProvider.getCurrentUser();
        }
        catch (PersistenceException exc) {
            String errorMessage = String.format("Cannot generate OAuth 2.0 SAML Bearer Assertion assertion because of %s", exc.toString());
            LOGGER.error(errorMessage, (Throwable)exc);
            throw new SAML2Exception(errorMessage, (Throwable)exc);
        }
        if (user == null) {
            LOGGER.debug("There is no currently lopgged in user, using user ID supplied from destination property SystemUser");
        } else {
            LOGGER.debug("Currently logged user is {}", (Object)user.toString());
        }
        return user;
    }

    private SAML2AttributeStatement createSAML2AttributeStatements(SAML2BearerAssertionData data, User user) throws SAML2Exception {
        SAML2DataFactory saml2DataFactory = SAML2DataFactory.getInstance();
        ArrayList<SAML2Attribute> attributesOrEncryptedAttributes = new ArrayList<SAML2Attribute>();
        Map<String, List<Object>> attributes = data.getAttributes();
        if (attributes != null && attributes.keySet() != null) {
            for (String attributeKey : attributes.keySet()) {
                SAML2Attribute attribute = saml2DataFactory.createSAML2Attribute(attributeKey);
                attribute.setAttributeValues(attributes.get(attributeKey));
                attributesOrEncryptedAttributes.add(attribute);
            }
        }
        try {
            if (threadLocal.get() == null) {
                threadLocal.set(1);
                if (user != null && data.getUserId() != null && data.getUserId().equalsIgnoreCase(user.getName())) {
                    this.addUserAttributes(user, saml2DataFactory, attributesOrEncryptedAttributes);
                }
                this.addLandscapeAttributes(saml2DataFactory, attributesOrEncryptedAttributes);
            }
        }
        finally {
            threadLocal.remove();
        }
        SAML2AttributeStatement attributeStatement = saml2DataFactory.createSAML2AttributeStatement(attributesOrEncryptedAttributes);
        return attributeStatement;
    }

    private void addLandscapeAttributes(SAML2DataFactory saml2DataFactory, List<SAML2Attribute> attributesOrEncryptedAttributes) throws SAML2Exception {
        String landscapeName;
        String hostName;
        String tenantId;
        String applicationName;
        String accountName = this.getSystemProperty("HC_ACCOUNT");
        if (accountName != null) {
            SAML2Attribute attribute = this.createSAML2Attribute(saml2DataFactory, "accountname", accountName);
            attributesOrEncryptedAttributes.add(attribute);
        }
        if ((applicationName = this.getSystemProperty("HC_APPLICATION")) != null) {
            SAML2Attribute attribute = this.createSAML2Attribute(saml2DataFactory, "applicationname", applicationName);
            attributesOrEncryptedAttributes.add(attribute);
        }
        if ((tenantId = this.getTenantId()) != null) {
            SAML2Attribute attribute = this.createSAML2Attribute(saml2DataFactory, "tenantId", tenantId);
            attributesOrEncryptedAttributes.add(attribute);
        }
        if ((hostName = this.getSystemProperty("HC_HOST")) != null) {
            SAML2Attribute attribute = this.createSAML2Attribute(saml2DataFactory, "hostname", hostName);
            attributesOrEncryptedAttributes.add(attribute);
        }
        if ((landscapeName = this.getSystemProperty("HC_LANDSCAPE")) != null) {
            SAML2Attribute attribute = this.createSAML2Attribute(saml2DataFactory, "landscapename", landscapeName);
            attributesOrEncryptedAttributes.add(attribute);
        }
    }

    String getTenantId() {
        return Tenant.getId();
    }

    private void addUserAttributes(User user, SAML2DataFactory saml2DataFactory, List<SAML2Attribute> attributesOrEncryptedAttributes) throws SAML2Exception {
        Set roles;
        for (String attributeName : user.listAttributes()) {
            String[] attributeValues = user.getAttributeValues(attributeName);
            SAML2Attribute attribute = saml2DataFactory.createSAML2Attribute(attributeName);
            attribute.setAttributeValues(new ArrayList<String>(Arrays.asList(attributeValues)));
            attributesOrEncryptedAttributes.add(attribute);
        }
        Set groups = user.getGroups();
        if (groups != null && groups.size() > 0) {
            SAML2Attribute attribute = this.createSAML2Attribute(saml2DataFactory, "com.sap.core.jpaas.security.um.groups", groups);
            attributesOrEncryptedAttributes.add(attribute);
        }
        if ((roles = user.getRoles()) != null && roles.size() > 0) {
            SAML2Attribute attribute = this.createSAML2Attribute(saml2DataFactory, "com.sap.core.jpaas.security.um.roles", roles);
            attributesOrEncryptedAttributes.add(attribute);
        }
    }

    private SAML2Attribute createSAML2Attribute(SAML2DataFactory saml2DataFactory, String attributeKey, Set<String> attributeValues) throws SAML2Exception {
        SAML2Attribute attribute = saml2DataFactory.createSAML2Attribute(attributeKey);
        ArrayList<String> values = new ArrayList<String>();
        values.addAll(attributeValues);
        attribute.setAttributeValues(values);
        return attribute;
    }

    private SAML2Attribute createSAML2Attribute(SAML2DataFactory saml2DataFactory, String attributeKey, String attributeValue) throws SAML2Exception {
        HashSet<String> attributeValues = new HashSet<String>();
        attributeValues.add(attributeValue);
        return this.createSAML2Attribute(saml2DataFactory, attributeKey, attributeValues);
    }

    private List<SAML2SubjectConfirmation> createSubjectConfirmations(SAML2BearerAssertionData data, SAML2LocalIdP idpConfig) throws SAML2Exception {
        SAML2DataFactory saml2DataFactory = SAML2DataFactory.getInstance();
        SAML2SubjectConfirmation confirmation = saml2DataFactory.createSAML2SubjectConfirmation("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        SAML2SubjectConfirmationData subjConfData = saml2DataFactory.createSAML2SubjectConfirmationData();
        subjConfData.setRecipient(data.getRecepientURI());
        subjConfData.setNotOnOrAfter(new Date(System.currentTimeMillis() + (long)idpConfig.getAssertionValidityNotAfterInMinutes() * 60L * 1000L));
        confirmation.setSubjectConfirmationData(subjConfData);
        ArrayList<SAML2SubjectConfirmation> confirmations = new ArrayList<SAML2SubjectConfirmation>();
        confirmations.add(confirmation);
        return confirmations;
    }

    private SAML2NameID createSaml2NameId(SAML2BearerAssertionData data, User user) throws SAML2Exception {
        SAML2DataFactory saml2DataFactory = SAML2DataFactory.getInstance();
        String id = data.getUserId();
        if (data.getUserIDSource() != null) {
            if (user == null) {
                throw new SAML2Exception("Cannot generate OAuth 2.0 SAML Bearer Assertion assertion. User ID source attribute was supplied, but there is no currently logged in user");
            }
            id = this.retrieveUserAttributeValue(user, data.getUserIDSource());
        }
        SAML2NameID subjectNameId = saml2DataFactory.createSAML2NameID(id);
        if (data.getNameIDFormat() != null) {
            subjectNameId.setFormat(data.getNameIDFormat());
        } else {
            subjectNameId.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        }
        subjectNameId.setNameQualifier(data.getNameQualifier());
        subjectNameId.setSPNameQualifier(data.getsPNameQualifier());
        subjectNameId.setSPProvidedID(data.getsPProvidedID());
        return subjectNameId;
    }

    private String retrieveUserAttributeValue(User currentUser, String attributeName) throws SAML2Exception {
        try {
            return currentUser.getAttribute(attributeName);
        }
        catch (UnsupportedUserAttributeException e) {
            throw new SAML2Exception("Cannot generate OAuth 2.0 SAML Bearer Assertion assertion because user id source attribute name " + attributeName + " is not valid attrbute name", (Throwable)e);
        }
    }
}

