/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service;

import com.sap.core.jpaas.security.saml2.service.SAML2ServiceConfigurationAccessor;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2ServiceConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SAML2ServiceConfiguration.class);
    public static final String CFG_EXPIRATION_TIME_DFEAULT = "120";
    public static final String CFG_EXPIRATION_TIME_KEY = "cfg_expiration_time";
    public static final String PROVIDER_EXCLUDE_LIST_DFEAULT = "jpaas.developer;prod.jpaas.sapbydesign.com;sp.leanserver.com;sp.gravity.sandbox.streamwork.com";
    public static final String PROVIDER_EXCLUDE_LIST_KEY = "provider_exclude_list";
    private long cfgExpirationTime;
    private Set<String> excludedProviders;
    private Dictionary configuration = null;
    private static SAML2ServiceConfiguration instance;

    public static synchronized SAML2ServiceConfiguration getInstance() {
        if (instance == null) {
            instance = new SAML2ServiceConfiguration();
            instance.checkConfiguration();
        }
        return instance;
    }

    public long getCfgExpirationTime() {
        return this.cfgExpirationTime;
    }

    public Set<String> getExcludedProviders() {
        return this.excludedProviders;
    }

    public void updateProperties(Dictionary saml2Properties) {
        if (saml2Properties != null) {
            Long cfgExpirationTimeSec = Long.parseLong(SAML2ServiceConfiguration.getProperty(saml2Properties, CFG_EXPIRATION_TIME_KEY, CFG_EXPIRATION_TIME_DFEAULT));
            this.cfgExpirationTime = cfgExpirationTimeSec * 1000L;
            this.excludedProviders = SAML2ServiceConfiguration.getPropertyAsSet(saml2Properties, PROVIDER_EXCLUDE_LIST_KEY, PROVIDER_EXCLUDE_LIST_DFEAULT);
            this.configuration = saml2Properties;
        } else {
            this.setDefaultValues();
        }
    }

    private void checkConfiguration() {
        if (this.configuration == null) {
            this.updateProperties(SAML2ServiceConfigurationAccessor.getConfiguration());
        }
    }

    private synchronized void setDefaultValues() {
        logger.warn("Property file for reading saml2 configuration can not be found. The default values will be used in this case.");
        this.cfgExpirationTime = Long.parseLong(CFG_EXPIRATION_TIME_DFEAULT) * 1000L;
        this.excludedProviders = SAML2ServiceConfiguration.getPropertyAsSet(PROVIDER_EXCLUDE_LIST_DFEAULT);
    }

    private static String getProperty(Dictionary properties, String key, String defaultValue) {
        String value = (String)properties.get(key);
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        return value.trim();
    }

    private static Set<String> getPropertyAsSet(Dictionary properties, String key, String defaultValue) {
        String valueList = SAML2ServiceConfiguration.getProperty(properties, key, defaultValue).trim();
        return SAML2ServiceConfiguration.getPropertyAsSet(valueList);
    }

    private static Set<String> getPropertyAsSet(String valueList) {
        String[] tokens;
        HashSet<String> propertiesSet = new HashSet<String>();
        if (valueList != null && valueList.trim().length() > 0 && (tokens = valueList.split(";")) != null) {
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                propertiesSet.add(token.trim());
                ++n2;
            }
        }
        return propertiesSet;
    }
}

