/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service;

import com.sap.core.jpaas.security.saml2.service.SAML2ServiceConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2ServiceConfigurationAccessor {
    private static final String SAML_CFG_CONFIG_FOLDER = "com.sap.core.jpaas.security.saml2.cfg";
    private static final String CONFIG_MASTER = "config_master";
    static final String SAML2_PROPERTIES = "saml2.properties";
    static final String SAML_SERVICE_CONFIGURATION_PATH = "./config_master" + File.separator + "com.sap.core.jpaas.security.saml2.cfg";
    private static final Logger logger = LoggerFactory.getLogger(SAML2ServiceConfigurationAccessor.class);
    private static Dictionary configuration = null;

    public static Dictionary getConfiguration() {
        if (configuration == null) {
            SAML2ServiceConfigurationAccessor.readConfiguration();
        }
        return configuration;
    }

    private static synchronized void readConfiguration() {
        try {
            logger.debug("Reading configuration saml2.properties from configuration folder");
            File configFile = new File(SAML_SERVICE_CONFIGURATION_PATH, SAML2_PROPERTIES);
            try (FileInputStream configFileInput = null;){
                configFileInput = new FileInputStream(configFile);
                Properties config = new Properties();
                config.load(configFileInput);
                configuration = config;
            }
        }
        catch (IOException e) {
            logger.warn("Cannot access configuration saml2.properties from local configuration service; default values will be used", (Throwable)e);
            configuration = null;
        }
    }

    static void updateProperties(Dictionary props) {
        configuration = props;
        SAML2ServiceConfiguration.getInstance().updateProperties(props);
    }
}

