/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service;

import com.sap.core.jpaas.security.saml2.service.cfg.SAML2ConfigurationJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2LocalSPJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.accessor.ConfigurationAccessor;
import com.sap.core.jpaas.security.saml2.service.cfg.accessor.ConfigurationAccessorFactory;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2IdPConfiguration;
import com.sap.security.saml2.idp.api.AssertionData;
import com.sap.security.saml2.idp.api.SAML2IdPAPI;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2Response;
import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.UnsupportedUserAttributeException;
import com.sap.security.um.user.User;
import com.sap.security.um.user.UserProvider;
import com.sap.security.um.user.ext.UserEx;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2TokenService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAML2TokenService.class);
    private static SAML2TokenService instance;

    SAML2TokenService() {
    }

    public static synchronized SAML2TokenService getInstance() {
        if (instance == null) {
            instance = new SAML2TokenService();
        }
        return instance;
    }

    public String generateSSOToken(String destinationURL) throws SAML2Exception {
        return this.generateSSOToken(destinationURL, null);
    }

    public String generateSSOToken(String destinationURL, String audience) throws SAML2Exception {
        SAML2ConfigurationJPaaSImpl samlConfiguration = this.getSamlConfiguration();
        if (audience == null) {
            audience = this.getLocalSpName(samlConfiguration);
            return this.generateSAMLResponse(samlConfiguration, destinationURL, audience, false);
        }
        return this.generateSAMLResponse(samlConfiguration, destinationURL, audience, true);
    }

    private String generateSAMLResponse(SAML2ConfigurationJPaaSImpl samlConfiguration, String destinationURL, String audience, boolean forExternalSP) throws SAML2Exception {
        User user = this.getUser();
        LOGGER.debug("Generating SAML2 token for destination URL [{}], audience [{}] and user [{}]", new Object[]{destinationURL, audience, user.getName()});
        try {
            AssertionData data = this.generateAssertionData(user);
            SAML2IdPAPI idpApi = SAML2IdPAPI.getInstance();
            SAML2Response saml2response = forExternalSP ? idpApi.createSSOResponseForExternalSP((SAML2IdPConfiguration)samlConfiguration, audience, destinationURL, data) : idpApi.createSSOResponse((SAML2IdPConfiguration)samlConfiguration, audience, destinationURL, data);
            String encodedResponse = SAML2Utils.encodeBase64AsString((String)saml2response.generate());
            LOGGER.debug("Generated encoded SAML2 token to be send [{}]", (Object)encodedResponse);
            return encodedResponse;
        }
        catch (SAML2Exception e) {
            this.logGenerationException((Exception)((Object)e));
            throw e;
        }
        catch (SAML2ConfigurationException e) {
            this.logGenerationException((Exception)((Object)e));
            throw new SAML2Exception((Throwable)e);
        }
    }

    private String getLocalSpName(SAML2ConfigurationJPaaSImpl idpConfiguration) throws SAML2Exception {
        SAML2LocalSPJPaaSImpl localSP = idpConfiguration.getLocalSP();
        if (localSP == null) {
            throw new SAML2Exception("Local Service Provider configuration retrieved from saml2 configuration is null.");
        }
        String spName = localSP.getName();
        if (spName == null) {
            throw new SAML2Exception("Local Service Provider name retrieved from saml2 configuration is null.");
        }
        return spName;
    }

    private SAML2ConfigurationJPaaSImpl getSamlConfiguration() throws SAML2Exception {
        SAML2ConfigurationJPaaSImpl samlConfiguration = this.getConfigurationReader().getConfiguration();
        if (samlConfiguration == null) {
            throw new SAML2Exception("Default configuration retrieved from saml2 json is null.");
        }
        LOGGER.debug("SAML configuration retrieved []", (Object)samlConfiguration);
        return samlConfiguration;
    }

    ConfigurationAccessor getConfigurationReader() {
        return ConfigurationAccessorFactory.createApplicationConfigurationAccessor();
    }

    User getUser() throws SAML2Exception {
        User user = null;
        try {
            UserProvider userProvider = UserManagementAccessor.getUserProvider();
            user = userProvider.getCurrentUser();
        }
        catch (PersistenceException exc) {
            LOGGER.error("Error has occurred while retrieving details of currently logged user", (Throwable)exc);
            throw new SAML2Exception((Throwable)exc);
        }
        if (user == null) {
            throw new SAML2Exception("No logged in user.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Currently logged user is {}", (Object)this.printUser(user));
        }
        return user;
    }

    private AssertionData generateAssertionData(User user) {
        UserEx extUser;
        Set groups;
        HashMap attributes = new HashMap();
        for (String attributeName : user.listAttributes()) {
            List<String> attributeValues = new ArrayList<String>();
            if (user instanceof UserEx) {
                attributeValues = Arrays.asList(((UserEx)user).getAttributeValues(attributeName));
            } else {
                attributeValues.add(this.getAttributeValue(user, attributeName));
            }
            attributes.put(attributeName, attributeValues);
        }
        if (user instanceof UserEx && (groups = (extUser = (UserEx)user).getGroups()) != null && groups.size() > 0) {
            StringBuffer groupsBuffer = new StringBuffer();
            Iterator groupIter = groups.iterator();
            while (groupIter.hasNext()) {
                groupsBuffer.append((String)groupIter.next());
                if (!groupIter.hasNext()) continue;
                groupsBuffer.append(';');
            }
            ArrayList<String> groupsValue = new ArrayList<String>();
            groupsValue.add(groupsBuffer.toString());
            attributes.put("com.sap.core.jpaas.security.um.groups", groupsValue);
        }
        AssertionData data = new AssertionData(user.getName());
        data.setAttributes(attributes);
        return data;
    }

    private String printUser(User user) {
        if (user == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("user: ");
        sb.append(user.getName());
        sb.append("\r\n\r\n");
        sb.append("attributes:");
        for (String attributeName : user.listAttributes()) {
            sb.append("\r\n");
            sb.append(attributeName);
            sb.append("=");
            sb.append(this.getAttributeValue(user, attributeName));
        }
        return sb.toString();
    }

    private String getAttributeValue(User user, String attributeName) {
        try {
            return user.getAttribute(attributeName);
        }
        catch (UnsupportedUserAttributeException exc) {
            LOGGER.error("As the attributeName is returned by listAttributes(), the exception thrown is unexpected", (Throwable)exc);
            return "";
        }
    }

    private void logGenerationException(Exception exc) {
        LOGGER.error("Error during generation of SAMLResponse", (Throwable)exc);
    }
}

