/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service.cfg;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sap.core.jpaas.security.saml2.service.cfg.json.JPaaSSerializedName;
import com.sap.core.jpaas.security.saml2.service.cfg.json.SAML2Configuration;
import com.sap.security.saml2.lib.common.SAML2Utils;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(ConfigParser.class);

    public static Gson getGsonParser() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setFieldNamingStrategy(new FieldNamingStrategy(){

            public String translateName(Field field) {
                JPaaSSerializedName annotation = field.getAnnotation(JPaaSSerializedName.class);
                return annotation != null && annotation.value() != null ? annotation.value() : field.getName();
            }
        });
        gsonBuilder.setPrettyPrinting();
        return gsonBuilder.create();
    }

    public static SAML2Configuration parseSAML2Configuration(String json) {
        Gson gson = ConfigParser.getGsonParser();
        return (SAML2Configuration)gson.fromJson(json, SAML2Configuration.class);
    }

    public static void persistSAML2Configuration(String fileName, SAML2Configuration saml2figuration) throws IOException {
        Gson gson = ConfigParser.getGsonParser();
        String json = gson.toJson((Object)saml2figuration, SAML2Configuration.class);
        OutputStreamWriter writer = null;
        BufferedWriter out = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8");
            out = new BufferedWriter(writer);
            out.write(json);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static X509Certificate parseCertificate(String certBase64) {
        try {
            byte[] certRaw = SAML2Utils.decodeBase64((String)certBase64);
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certRaw));
            return cert;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("An error occurned while parsing base64 encoded certificate: " + certBase64, (Throwable)e);
            }
            throw new IllegalArgumentException("An error occurned while parsing base64 encoded certificate", e);
        }
    }

    public static PrivateKey parsePrivateKey(String privateKeyBase64, String keyAlgorithm) {
        try {
            byte[] keyRaw = SAML2Utils.decodeBase64((String)privateKeyBase64);
            KeyFactory keyFactory = null;
            keyFactory = "DSA".equalsIgnoreCase(keyAlgorithm) ? KeyFactory.getInstance("DSA") : KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(keyRaw);
            PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
            return privateKey;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("An error occurned while parsing base64 encoded private key: " + privateKeyBase64, (Throwable)e);
            }
            throw new IllegalArgumentException("An error occurned while parsing base64 encoded certificate", e);
        }
    }
}

