/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service.cfg;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationLogger {
    private static final String SIGNING_PRIVATE_KEY = "signing.private.key";
    private static final String LOCAL_PROVIDER = "local.provider";
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationLogger.class);

    public static void debug(String tenantId, String configuration) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        logger.debug("Retrived SAML configuraiton for tenant [{}]: [{}]", (Object)tenantId, (Object)ConfigurationLogger.getConfigurationForLog(configuration));
    }

    public static void debugLocalConfiguration(String configuration) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        logger.debug("Retrieved SAML configuration from the local file system: [{}]", (Object)ConfigurationLogger.getConfigurationForLog(configuration));
    }

    static String getConfigurationForLog(String configuration) {
        JsonElement localProvider;
        JsonObject parsedConfiguration;
        block4: {
            if (configuration == null) {
                return null;
            }
            try {
                JsonParser parser = new JsonParser();
                parsedConfiguration = parser.parse(configuration).getAsJsonObject();
                localProvider = parsedConfiguration.get(LOCAL_PROVIDER);
                if (localProvider != null && !localProvider.isJsonNull()) break block4;
                return null;
            }
            catch (Exception e) {
                logger.debug("An error occurred while preparing the configuration for log. Exception was: [{}]", (Object)e.getMessage());
                return null;
            }
        }
        localProvider.getAsJsonObject().remove(SIGNING_PRIVATE_KEY);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)parsedConfiguration);
    }
}

