/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service.cfg;

import com.sap.core.jpaas.security.saml2.service.cfg.ConfigParser;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2ConfigurationJPaaSIdPImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2LocalIdPJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2LocalSPJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2TrustedIdPJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.json.IdentityProviderConfiguration;
import com.sap.core.jpaas.security.saml2.service.cfg.json.LocalProviderConfiguration;
import com.sap.core.jpaas.security.saml2.service.cfg.json.SAML2Configuration;
import com.sap.core.jpaas.security.saml2.service.cfg.json.TrustedProvidersConfiguration;
import com.sap.security.saml2.cfg.custom.SAML2EndpointCustomImpl;
import com.sap.security.saml2.cfg.custom.SAML2LocalIdPCustomImpl;
import com.sap.security.saml2.cfg.custom.SAML2TrustedSPCustomImpl;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2Service;
import com.sap.security.saml2.cfg.interfaces.SAML2IdPConfiguration;
import com.sap.security.saml2.cfg.interfaces.SAML2SPConfiguration;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedSP;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2ConfigurationJPaaSImpl
implements SAML2SPConfiguration,
SAML2IdPConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SAML2ConfigurationJPaaSImpl.class);
    private SAML2LocalSPJPaaSImpl localSP;
    private Map<String, SAML2TrustedIdPJPaaSImpl> trustedIdPs;
    private Map<String, SAML2TrustedSP> trustedSPs;
    private SAML2LocalIdPCustomImpl localIdP;
    private boolean enabled = true;
    private boolean forceAuthentication = false;
    private SAML2ConfigurationJPaaSIdPImpl multiDomainIdp;
    private boolean isDefaultConfig;

    public SAML2ConfigurationJPaaSImpl(SAML2Configuration saml2Cfg) {
        this(saml2Cfg, null);
    }

    public SAML2ConfigurationJPaaSImpl(SAML2Configuration saml2Cfg, SAML2ConfigurationJPaaSImpl defaultConfig) {
        X509Certificate signingCertificate;
        PrivateKey signingPrivateKey;
        String name;
        boolean customType = false;
        String configurationType = saml2Cfg.getConfigurationType();
        boolean bl = this.isDefaultConfig = "Default".equals(configurationType) || configurationType == null;
        if (configurationType == null || !configurationType.equals("Default") && !configurationType.equals("None")) {
            customType = true;
        }
        LocalProviderConfiguration localProvider = saml2Cfg.getLocalProvider();
        if (customType || defaultConfig == null) {
            logger.debug("Custom SAML configuration is used.");
            name = localProvider.getName();
            signingPrivateKey = ConfigParser.parsePrivateKey(localProvider.getSigningPrivateKey(), localProvider.getSigningPrivateKeyAlgorithm());
            signingCertificate = ConfigParser.parseCertificate(localProvider.getSigningCertificate());
            this.trustedSPs = new HashMap<String, SAML2TrustedSP>();
            this.trustedSPs.put(name, (SAML2TrustedSP)new SAML2TrustedSPCustomImpl(name, signingCertificate, "http://localhost"));
            this.localSP = new SAML2LocalSPJPaaSImpl(name, signingPrivateKey, signingCertificate);
            this.localSP.setIsToSignMetadata(false);
            this.localSP.setAssertionConsumerSupportedBindings(new HashSet<SAML2Binding>(Arrays.asList(SAML2Binding.HTTP_POST_BINDING)));
            this.localSP.setAssertionConsumerLocation("saml2/sp/acs");
            this.localSP.setSingleLogoutSupportedBindings(new HashSet<SAML2Binding>(Arrays.asList(SAML2Binding.HTTP_REDIRECT_BINDING, SAML2Binding.HTTP_POST_BINDING)));
            this.localSP.setSingleLogoutLocation("saml2/sp/slo");
            this.localSP.setDefaultIDP(localProvider.getDefaultIdp());
            this.localSP.setPlainHTTPConnectionsEnabled("yes".equalsIgnoreCase(localProvider.getAllowHttp()));
            this.localSP.setMultiDomainServiceEnabled("true".equalsIgnoreCase(localProvider.getEnableMultiDomainService()));
            this.localSP.setEndpointsURL(localProvider.getEndpointsUrl());
            this.localSP.setEndpointsURLExtension(localProvider.getEndpointsUrlExtension());
            this.localSP.setApplicationDomains(localProvider.getApplicationDomains());
            if (localProvider.getForceAuthentication() != null && !localProvider.getForceAuthentication().equals("")) {
                this.forceAuthentication = Boolean.valueOf(localProvider.getForceAuthentication());
            }
            this.trustedIdPs = new HashMap<String, SAML2TrustedIdPJPaaSImpl>();
            List<IdentityProviderConfiguration> idpCfgList = saml2Cfg.getTrustedProviders().getIdentityProviders();
            if (idpCfgList != null) {
                for (IdentityProviderConfiguration idpCfg : idpCfgList) {
                    if (idpCfg.getName() != null) {
                        try {
                            SAML2TrustedIdPJPaaSImpl trustedIdP = new SAML2TrustedIdPJPaaSImpl(idpCfg);
                            this.trustedIdPs.put(idpCfg.getName(), trustedIdP);
                        }
                        catch (Exception e) {
                            logger.error("Error occured while creating trusted provider " + idpCfg.getName(), (Throwable)e);
                        }
                        continue;
                    }
                    logger.warn("There is a trusted provider with null name for local provider {}", (Object)this.localSP.getName());
                }
            }
            this.localIdP = new SAML2LocalIdPCustomImpl(name, signingPrivateKey, null);
            if (localProvider.getAllowAppToAppSso() == null || Boolean.valueOf(localProvider.getAllowAppToAppSso()).booleanValue()) {
                this.trustedIdPs.put(name, new SAML2TrustedIdPJPaaSImpl(name, signingCertificate));
            }
            if (this.localSP.isMultiDomainServiceEnabled()) {
                SAML2TrustedIdPJPaaSImpl multiDomainTrustedIdp = new SAML2TrustedIdPJPaaSImpl("local_multi_domain_idp", signingCertificate);
                String idpSLOEndpointURL = String.valueOf(this.localSP.getEndpointsURL()) + "/" + "saml2/sp/slo" + "/" + this.localSP.getEndpointsURLExtension() + "?" + "multiDomainLogout" + "=true";
                ArrayList<SAML2EndpointCustomImpl> endpoints = new ArrayList<SAML2EndpointCustomImpl>();
                SAML2EndpointCustomImpl defaltSLOEndpoint = new SAML2EndpointCustomImpl(SAML2Service.SINGLE_LOGOUT_SERVICE, SAML2Binding.HTTP_REDIRECT_BINDING, idpSLOEndpointURL);
                defaltSLOEndpoint.setDefault(true);
                endpoints.add(defaltSLOEndpoint);
                endpoints.add(new SAML2EndpointCustomImpl(SAML2Service.SINGLE_LOGOUT_SERVICE, SAML2Binding.HTTP_POST_BINDING, idpSLOEndpointURL));
                multiDomainTrustedIdp.setEndpoints(endpoints);
                this.trustedIdPs.put("local_multi_domain_idp", multiDomainTrustedIdp);
                this.multiDomainIdp = new SAML2ConfigurationJPaaSIdPImpl();
                SAML2LocalIdPJPaaSImpl localMultiDomainIdpImpl = new SAML2LocalIdPJPaaSImpl("local_multi_domain_idp", signingPrivateKey, signingCertificate);
                localMultiDomainIdpImpl.setSingleLogoutLocation(idpSLOEndpointURL);
                HashSet supportedBindings = new HashSet();
                localMultiDomainIdpImpl.setSingleLogoutSupportedBindings(supportedBindings);
                this.multiDomainIdp.setLocalIdP((SAML2LocalIdP)localMultiDomainIdpImpl);
                SAML2TrustedSPCustomImpl trustedSP = new SAML2TrustedSPCustomImpl(this.localSP.getName(), signingCertificate, this.localSP.getAssertionConsumerLocation(), this.localSP.getSingleLogoutLocation());
                this.multiDomainIdp.putTrustedSP(trustedSP);
            }
        }
        if (configurationType != null && configurationType.equals("Default") && defaultConfig != null) {
            logger.debug("There is SAML configuration with flag default.");
            this.initializeSAML2CfgFields(saml2Cfg, defaultConfig);
            if (localProvider != null) {
                name = localProvider.getName();
                signingPrivateKey = ConfigParser.parsePrivateKey(localProvider.getSigningPrivateKey(), localProvider.getSigningPrivateKeyAlgorithm());
                signingCertificate = ConfigParser.parseCertificate(localProvider.getSigningCertificate());
                this.localIdP = new SAML2LocalIdPCustomImpl(name, signingPrivateKey, null);
                if (localProvider.getForceAuthentication() != null && !localProvider.getForceAuthentication().equals("")) {
                    this.forceAuthentication = Boolean.valueOf(localProvider.getForceAuthentication());
                }
                if (localProvider.getAllowAppToAppSso() == null || Boolean.valueOf(localProvider.getAllowAppToAppSso()).booleanValue()) {
                    logger.debug("A2A is allowed so add local SP to trusted idps.");
                    this.trustedIdPs.put(name, new SAML2TrustedIdPJPaaSImpl(name, signingCertificate));
                }
            } else {
                this.localIdP = defaultConfig.getLocalIdP();
            }
        }
        if (configurationType != null && configurationType.equals("None")) {
            logger.debug("SAML is disabled");
            this.enabled = false;
        }
    }

    private void initializeSAML2CfgFields(SAML2Configuration saml2Cfg, SAML2ConfigurationJPaaSImpl defaultConfig) {
        this.localSP = defaultConfig.localSP;
        this.trustedIdPs = this.cloneTrustedIdPs(defaultConfig.trustedIdPs);
        this.trustedIdPs.remove(this.localSP.getName());
        this.trustedIdPs = this.addPasiveModeIdPsFromCfg(saml2Cfg, this.trustedIdPs);
        this.trustedSPs = defaultConfig.trustedSPs;
    }

    private Map<String, SAML2TrustedIdPJPaaSImpl> addPasiveModeIdPsFromCfg(SAML2Configuration saml2Cfg, Map<String, SAML2TrustedIdPJPaaSImpl> trustedIdPs) {
        List<IdentityProviderConfiguration> identityProviders;
        TrustedProvidersConfiguration trustedProviders = saml2Cfg.getTrustedProviders();
        if (trustedProviders != null && (identityProviders = trustedProviders.getIdentityProviders()) != null) {
            for (IdentityProviderConfiguration idPConfiguration : identityProviders) {
                if (!Boolean.parseBoolean(idPConfiguration.getUnsolicited())) continue;
                trustedIdPs.put(idPConfiguration.getName(), new SAML2TrustedIdPJPaaSImpl(idPConfiguration));
            }
        }
        return trustedIdPs;
    }

    public SAML2ConfigurationJPaaSIdPImpl getMultiDomainIdp() {
        return this.multiDomainIdp;
    }

    private Map<String, SAML2TrustedIdPJPaaSImpl> cloneTrustedIdPs(Map<String, SAML2TrustedIdPJPaaSImpl> trustedIdps) {
        if (trustedIdps == null) {
            return null;
        }
        HashMap<String, SAML2TrustedIdPJPaaSImpl> result = new HashMap<String, SAML2TrustedIdPJPaaSImpl>();
        result.putAll(trustedIdps);
        return result;
    }

    public SAML2LocalSPJPaaSImpl getLocalSP() {
        return this.localSP;
    }

    public SAML2TrustedIdPJPaaSImpl getTrustedIdP(String idpName) {
        return this.trustedIdPs.get(idpName);
    }

    public SAML2TrustedIdP getTrustedIdP(byte[] idpNameDigest) {
        throw new UnsupportedOperationException("Mehtod getTrustedIdP(byte[] idpNameDigest) is not supported in from SAML2SPConfigurationJPaaSImpl class");
    }

    public Collection<SAML2TrustedIdPJPaaSImpl> getTrustedProviders() {
        return this.trustedIdPs.values();
    }

    public SAML2LocalIdPCustomImpl getLocalIdP() {
        return this.localIdP;
    }

    public SAML2TrustedSP getTrustedSP(String name) {
        return this.trustedSPs.get(name);
    }

    public SAML2TrustedSP getTrustedSP(byte[] id) {
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isForceAuthentication() {
        return this.forceAuthentication;
    }

    public boolean isDefaultConfig() {
        return this.isDefaultConfig;
    }
}

