/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service.cfg;

import com.sap.core.jpaas.security.saml2.service.cfg.ConfigParser;
import com.sap.core.jpaas.security.saml2.service.cfg.json.LocalProviderConfiguration;
import com.sap.security.saml2.cfg.custom.SAML2LocalIdPCustomImpl;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class SAML2LocalIdPJPaaSImpl
extends SAML2LocalIdPCustomImpl {
    private String signingCertificate;
    private String privateKey;
    private String allowHttp;

    public SAML2LocalIdPJPaaSImpl(String name, String signingCertificate, String privateKey) throws Exception {
        super(name, SAML2LocalIdPJPaaSImpl.parsePrivateKey(privateKey), null);
        super.setSigningCertificate(SAML2LocalIdPJPaaSImpl.parseCertificate(signingCertificate));
        this.signingCertificate = signingCertificate;
        this.privateKey = privateKey;
    }

    public SAML2LocalIdPJPaaSImpl(LocalProviderConfiguration localProviderConfiguration) throws Exception {
        super(localProviderConfiguration.getName(), SAML2LocalIdPJPaaSImpl.parsePrivateKey(localProviderConfiguration.getSigningPrivateKey()), null);
        this.signingCertificate = localProviderConfiguration.getSigningCertificate();
        super.setSigningCertificate(SAML2LocalIdPJPaaSImpl.parseCertificate(this.signingCertificate));
        this.privateKey = localProviderConfiguration.getSigningPrivateKey();
        this.allowHttp = localProviderConfiguration.getAllowHttp();
    }

    public SAML2LocalIdPJPaaSImpl(String name, PrivateKey privateKey, X509Certificate certificate) {
        super(name, privateKey, null);
        super.setSigningCertificate(certificate);
    }

    public String getSigningCertificate() {
        return this.signingCertificate;
    }

    public String getAllowHttp() {
        return this.allowHttp;
    }

    public void setAllowHttp(String allowHttp) {
        this.allowHttp = allowHttp;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    private static PrivateKey parsePrivateKey(String privateKey) throws Exception {
        PrivateKey result = ConfigParser.parsePrivateKey(privateKey, "RSA");
        if (result == null) {
            throw new Exception("An error occurned while parsing base64 encoded private key: " + privateKey);
        }
        return result;
    }

    private static X509Certificate parseCertificate(String cert) throws Exception {
        X509Certificate result = ConfigParser.parseCertificate(cert);
        if (result == null) {
            throw new Exception("An error occurned while parsing base64 encoded certificate: " + cert);
        }
        return result;
    }
}

