/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service.cfg;

import com.sap.core.jpaas.security.saml2.service.cfg.ConfigParser;
import com.sap.core.jpaas.security.saml2.service.cfg.json.AssertionBasedAttribute;
import com.sap.core.jpaas.security.saml2.service.cfg.json.AssertionBasedGroup;
import com.sap.core.jpaas.security.saml2.service.cfg.json.DefaultAttribute;
import com.sap.core.jpaas.security.saml2.service.cfg.json.DefaultGroup;
import com.sap.core.jpaas.security.saml2.service.cfg.json.IdentityProviderConfiguration;
import com.sap.security.saml2.cfg.custom.SAML2TrustedIdPCustomImpl;
import com.sap.security.saml2.cfg.enums.DigestAlgorithm;
import com.sap.security.saml2.cfg.enums.ResponseRequirementType;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class SAML2TrustedIdPJPaaSImpl
extends SAML2TrustedIdPCustomImpl {
    private ResponseRequirementType responseRequirementType = ResponseRequirementType.IDP_DEFAULT;
    private String idpSSOBinding = null;
    private String idpSLOBinding = null;
    private String ssoAcsUrl = null;
    private String userIDSourceType;
    private String userIDSourceValue;
    private String userIDPrefix;
    private String userIDSuffix;
    private List<DefaultAttribute> defaultAttributesList;
    private List<AssertionBasedAttribute> assertionBasedAttributesList;
    private List<String> defaultGroupsList;
    private List<AssertionBasedGroup> assertionBasedGroupsList;
    private boolean enabled;
    private boolean unsolicited;

    public SAML2TrustedIdPJPaaSImpl(IdentityProviderConfiguration cfg) {
        super(cfg.getName(), ConfigParser.parseCertificate(cfg.getSigningCertificate()), cfg.getSsoUrl(), cfg.getSloUrl(), null);
        this.setSignAuthnRequests(true);
        String digestAlgorithm = cfg.getSignatureAlgorithm();
        if ("SHA-1".equalsIgnoreCase(digestAlgorithm)) {
            this.setDigestAlgorithm(DigestAlgorithm.SHA1);
        } else if ("SHA-256".equalsIgnoreCase(digestAlgorithm)) {
            this.setDigestAlgorithm(DigestAlgorithm.SHA256);
        }
        this.idpSSOBinding = cfg.getSsoBinding();
        this.ssoAcsUrl = "".equals(cfg.getAuthnRequestAcsurl()) ? null : cfg.getAuthnRequestAcsurl();
        this.idpSLOBinding = cfg.getSloBinding();
        this.userIDSourceType = cfg.getUseridSource().getType();
        this.userIDSourceValue = cfg.getUseridSource().getValue();
        this.userIDPrefix = cfg.getUseridPrefix();
        this.userIDSuffix = cfg.getUseridSuffix();
        this.defaultAttributesList = cfg.getDefaultAttributes();
        this.assertionBasedAttributesList = cfg.getAssertionBasedAttributes();
        this.assertionBasedGroupsList = cfg.getAssertionBasedGroups();
        this.defaultGroupsList = new ArrayList<String>();
        List<DefaultGroup> groupsList = cfg.getDefaultGroups();
        if (groupsList != null) {
            for (DefaultGroup defaultGroup : groupsList) {
                this.defaultGroupsList.add(defaultGroup.getGroup());
            }
        }
        this.enabled = Boolean.valueOf(cfg.getEnabled());
        this.unsolicited = Boolean.valueOf(cfg.getUnsolicited());
    }

    public SAML2TrustedIdPJPaaSImpl(String idpName, X509Certificate signingCertificate) {
        super(idpName, signingCertificate, "");
        this.responseRequirementType = ResponseRequirementType.IDP_DEFAULT;
        this.idpSSOBinding = null;
        this.idpSLOBinding = null;
        this.ssoAcsUrl = null;
        this.userIDSourceType = "assertion_subject";
        this.userIDSourceValue = null;
        this.userIDPrefix = null;
        this.userIDSuffix = null;
        this.defaultAttributesList = new ArrayList<DefaultAttribute>();
        ArrayList<AssertionBasedAttribute> assertionBasedAttributesList = new ArrayList<AssertionBasedAttribute>();
        AssertionBasedAttribute assertionBasedAttribute = new AssertionBasedAttribute();
        assertionBasedAttribute.setAssertionAttribute("*");
        assertionBasedAttribute.setPrincipalAttribute(null);
        assertionBasedAttributesList.add(assertionBasedAttribute);
        this.assertionBasedAttributesList = assertionBasedAttributesList;
        this.defaultGroupsList = new ArrayList<String>();
        this.assertionBasedGroupsList = new ArrayList<AssertionBasedGroup>();
        this.enabled = true;
    }

    public ResponseRequirementType getResponseRequirementType() {
        return this.responseRequirementType;
    }

    public void setResponseRequirementType(ResponseRequirementType responseRequirementType) {
        this.responseRequirementType = responseRequirementType;
    }

    public String getIdpSSOBinding() {
        return this.idpSSOBinding;
    }

    public void setIdpSSOBinding(String idpSSOBinding) {
        this.idpSSOBinding = idpSSOBinding;
    }

    public String getIdpSLOBinding() {
        return this.idpSLOBinding;
    }

    public void setIdpSLOBinding(String idpSLOBinding) {
        this.idpSLOBinding = idpSLOBinding;
    }

    public String getSsoAcsUrl() {
        return this.ssoAcsUrl;
    }

    public void setSsoAcsUrl(String ssoAcsUrl) {
        this.ssoAcsUrl = ssoAcsUrl;
    }

    public String getUserIDSourceType() {
        return this.userIDSourceType;
    }

    public void setUserIDSourceType(String userIDSourceType) {
        this.userIDSourceType = userIDSourceType;
    }

    public String getUserIDSourceValue() {
        return this.userIDSourceValue;
    }

    public void setUserIDSourceValue(String userIDSourceValue) {
        this.userIDSourceValue = userIDSourceValue;
    }

    public String getUserIDPrefix() {
        return this.userIDPrefix;
    }

    public void setUserIDPrefix(String userIDPrefix) {
        this.userIDPrefix = userIDPrefix;
    }

    public String getUserIDSuffix() {
        return this.userIDSuffix;
    }

    public void setUserIDSuffix(String userIDSuffix) {
        this.userIDSuffix = userIDSuffix;
    }

    public List<DefaultAttribute> getDefaultAttributesList() {
        return this.defaultAttributesList;
    }

    public void setDefaultAttributesList(List<DefaultAttribute> defaultAttributesList) {
        this.defaultAttributesList = defaultAttributesList;
    }

    public List<AssertionBasedAttribute> getAssertionBasedAttributesList() {
        return this.assertionBasedAttributesList;
    }

    public void setAssertionBasedAttributesList(List<AssertionBasedAttribute> assertionBasedAttributesList) {
        this.assertionBasedAttributesList = assertionBasedAttributesList;
    }

    public List<String> getDefaultGroupsList() {
        return this.defaultGroupsList;
    }

    public void setDefaultGroupsList(List<String> defaultGroupsList) {
        this.defaultGroupsList = defaultGroupsList;
    }

    public List<AssertionBasedGroup> getAssertionBasedGroupsList() {
        return this.assertionBasedGroupsList;
    }

    public void setAssertionBasedGroupsList(List<AssertionBasedGroup> assertionBasedGroupsList) {
        this.assertionBasedGroupsList = assertionBasedGroupsList;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setUnsolicited(boolean unsolicited) {
        this.unsolicited = unsolicited;
    }

    public boolean isUnsolicited() {
        return this.unsolicited;
    }
}

