/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service.cfg.accessor;

import com.sap.core.jpaas.security.saml2.service.cfg.SAML2ConfigurationJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.exp.ConfigurationRetrievingException;
import com.sap.core.jpaas.security.utils.TenantRetriever;
import com.sap.core.jpaas.security.utils.cache.TenantCache;
import com.sap.core.tenant.api.Tenant;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationAccessor {
    public static final String DEFAULT_TENANT_ID = "default_tenant_id";
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationAccessor.class);
    private static ConcurrentHashMap<String, String> accountTenantCache = new ConcurrentHashMap(1000);
    private TenantCache<SAML2ConfigurationJPaaSImpl> configurationCache;

    public ConfigurationAccessor(TenantCache<SAML2ConfigurationJPaaSImpl> configurationCache) {
        this.configurationCache = configurationCache;
    }

    public SAML2ConfigurationJPaaSImpl getConfiguration() {
        String tenantId = this.getCurrentTenant();
        return this.getConfiguration(tenantId);
    }

    public SAML2ConfigurationJPaaSImpl getConfiguration(String account, String tenantAlias) {
        String tenantId = null;
        tenantId = account == null && tenantAlias == null ? DEFAULT_TENANT_ID : this.getTenantId(account, tenantAlias);
        return this.getConfiguration(tenantId);
    }

    public SAML2ConfigurationJPaaSImpl getConfiguration(String tenantId) {
        if (tenantId == null) {
            tenantId = DEFAULT_TENANT_ID;
        }
        logger.debug("Entering getConfiguration for tenant [{}].", (Object)tenantId);
        SAML2ConfigurationJPaaSImpl samlConfiguration = (SAML2ConfigurationJPaaSImpl)this.configurationCache.getTenantCacheEntry(tenantId).getValue();
        logger.debug("Retrieved configuration: [{}] for tenant [{}]", (Object)samlConfiguration, (Object)tenantId);
        return samlConfiguration;
    }

    protected String getTenantId(String account, String tenantAlias) {
        String tenantId = this.safeGetFromTenantCache(tenantAlias);
        if (tenantId == null) {
            logger.debug("Tenant ID for alias [{}] was not found in the cache. A retrieving request to Domain DB will be performed.", (Object)account, (Object)tenantAlias);
            tenantId = this.fetchTenantFromDomainDb(account, tenantAlias);
            logger.debug("Tenant ID: [{}] for account [{}] and  tenant alias [{}] was successfully retrieved.", new Object[]{tenantId, account, tenantAlias});
            this.safePutTenantIdInCache(account, tenantAlias, tenantId);
        }
        return tenantId;
    }

    private String safeGetFromTenantCache(String tenantAlias) {
        if (tenantAlias == null) {
            return null;
        }
        return accountTenantCache.get(tenantAlias);
    }

    private String fetchTenantFromDomainDb(String account, String tenantAlias) {
        try {
            if (tenantAlias == null) {
                logger.debug("Tenant alias is not provided so retrieving default tenant name for account [{}] from domainDB", (Object)account);
                return this.fetchDefaultTenantOfAccount(account);
            }
            logger.debug("Retrieving tenant name for tenant alias [{}] from domainDB", (Object)tenantAlias);
            return this.fetchTenantIdByAlias(tenantAlias);
        }
        catch (Exception exception) {
            String errorMsg = "Could not retrieve tenant for account " + account + " and alias " + tenantAlias + " form DomainDB.";
            logger.error(errorMsg, (Throwable)exception);
            throw new ConfigurationRetrievingException(errorMsg, exception);
        }
    }

    private void safePutTenantIdInCache(String account, String tenantAlias, String tenantId) {
        if (tenantAlias != null) {
            accountTenantCache.put(tenantAlias, tenantId);
        } else {
            accountTenantCache.put(account, tenantId);
        }
    }

    String getCurrentTenant() {
        return Tenant.getId();
    }

    String fetchDefaultTenantOfAccount(String account) throws IOException {
        return new TenantRetriever().fetchDefaultTenantNameForAccount(account);
    }

    String fetchTenantIdByAlias(String tenantAlias) throws IOException {
        return new TenantRetriever().fetchTenantNameByAlias(tenantAlias);
    }
}

