/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service.cfg.accessor;

import com.sap.core.jpaas.security.saml2.service.cfg.SAML2ConfigurationJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.accessor.ConfigurationAccessor;
import com.sap.core.jpaas.security.saml2.service.cfg.cache.AdminConfigurationCacheReader;
import com.sap.core.jpaas.security.saml2.service.cfg.cache.ApplicationConfigurationCacheReader;
import com.sap.core.jpaas.security.saml2.service.cfg.readers.ConfigurationReaderFactory;
import com.sap.core.jpaas.security.utils.cache.TenantCache;
import com.sap.core.jpaas.security.utils.cache.TenantCacheValueReader;

public class ConfigurationAccessorFactory {
    private static final int SYNC_TIMEOUT_IN_MS = Integer.getInteger("com.sap.core.jpaas.security.saml2.service.cfg.SyncTimeoutInMs", 600000);
    private static final int ASYNC_TIMEOUT_IN_MS = Integer.getInteger("com.sap.core.jpaas.security.saml2.service.cfg.AsyncTimeoutInMs", 120000);
    private static final Object LOCK = new Object();
    private static ConfigurationAccessor adminConfiguration;
    private static ConfigurationAccessor applicationConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationAccessor createAdminConfigurationAccessor() {
        if (adminConfiguration == null) {
            Object object = LOCK;
            synchronized (object) {
                if (adminConfiguration == null) {
                    AdminConfigurationCacheReader reader = new AdminConfigurationCacheReader(ConfigurationAccessorFactory.createApplicationConfigurationCacheReader());
                    adminConfiguration = new ConfigurationAccessor((TenantCache<SAML2ConfigurationJPaaSImpl>)new TenantCache((TenantCacheValueReader)reader, (long)ASYNC_TIMEOUT_IN_MS, (long)SYNC_TIMEOUT_IN_MS));
                }
            }
        }
        return adminConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationAccessor createApplicationConfigurationAccessor() {
        if (applicationConfiguration == null) {
            Object object = LOCK;
            synchronized (object) {
                if (applicationConfiguration == null) {
                    ApplicationConfigurationCacheReader reader = ConfigurationAccessorFactory.createApplicationConfigurationCacheReader();
                    applicationConfiguration = new ConfigurationAccessor((TenantCache<SAML2ConfigurationJPaaSImpl>)new TenantCache((TenantCacheValueReader)reader, (long)ASYNC_TIMEOUT_IN_MS, (long)SYNC_TIMEOUT_IN_MS));
                }
            }
        }
        return applicationConfiguration;
    }

    private static ApplicationConfigurationCacheReader createApplicationConfigurationCacheReader() {
        return new ApplicationConfigurationCacheReader(ConfigurationReaderFactory.createDefaultConfigurationReader());
    }
}

