/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service.cfg.cache;

import com.sap.core.jpaas.security.saml2.service.cfg.ConfigParser;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2ConfigurationJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.json.SAML2Configuration;
import com.sap.core.jpaas.security.saml2.service.cfg.readers.ConfigurationReader;
import com.sap.core.jpaas.security.saml2.service.cfg.readers.ConfigurationReaderFactory;
import com.sap.core.jpaas.security.utils.TenantRetriever;
import com.sap.core.jpaas.security.utils.cache.TenantCacheValueReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminConfigurationCacheReader
implements TenantCacheValueReader<SAML2ConfigurationJPaaSImpl> {
    private static final Logger logger = LoggerFactory.getLogger(AdminConfigurationCacheReader.class);
    static String providerAccountTenantId;
    private TenantCacheValueReader<SAML2ConfigurationJPaaSImpl> applicationConfigurationCacheReader;

    public AdminConfigurationCacheReader(TenantCacheValueReader<SAML2ConfigurationJPaaSImpl> applicationConfigurationCacheReader) {
        this.applicationConfigurationCacheReader = applicationConfigurationCacheReader;
    }

    public SAML2ConfigurationJPaaSImpl readValue(String tenantId, SAML2ConfigurationJPaaSImpl currentValue) {
        try {
            logger.debug("Entering readValue with tenantId {} and current value {}", (Object)tenantId, (Object)currentValue);
            ConfigurationReader configurationReader = this.createConfigurationReader(tenantId);
            String configuration = configurationReader.read();
            if (configuration == null) {
                logger.debug("Trust configuration was not found, the default one will be used.");
                return (SAML2ConfigurationJPaaSImpl)this.applicationConfigurationCacheReader.readValue(this.resolveProviderAccountTenantId(), (Object)currentValue);
            }
            return this.toSamlConfiguration(configuration);
        }
        catch (IOException exception) {
            logger.error("Failed to retrieve the configuration from Domain DB, so the cached one will be used.", (Throwable)exception);
            return currentValue;
        }
    }

    private String resolveProviderAccountTenantId() throws IOException {
        if (providerAccountTenantId == null) {
            providerAccountTenantId = this.fetchDefaultTenantOfAccount(this.getAccountName());
        }
        return providerAccountTenantId;
    }

    ConfigurationReader createConfigurationReader(String tenantId) {
        return ConfigurationReaderFactory.createAdminConfigurationReader(tenantId);
    }

    String getAccountName() {
        return System.getenv("HC_ACCOUNT");
    }

    String fetchDefaultTenantOfAccount(String account) throws IOException {
        return new TenantRetriever().fetchDefaultTenantNameForAccount(account);
    }

    private SAML2ConfigurationJPaaSImpl toSamlConfiguration(String configuration) throws IOException {
        SAML2Configuration saml2Configuration = ConfigParser.parseSAML2Configuration(configuration);
        return new SAML2ConfigurationJPaaSImpl(saml2Configuration);
    }
}

