/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service.cfg.cache;

import com.sap.core.jpaas.security.saml2.service.cfg.ConfigParser;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2ConfigurationJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.json.SAML2Configuration;
import com.sap.core.jpaas.security.saml2.service.cfg.readers.ConfigurationReader;
import com.sap.core.jpaas.security.saml2.service.cfg.readers.ConfigurationReaderFactory;
import com.sap.core.jpaas.security.utils.cache.TenantCacheValueReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationConfigurationCacheReader
implements TenantCacheValueReader<SAML2ConfigurationJPaaSImpl> {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationConfigurationCacheReader.class);
    private ConfigurationReader defaultConfigurationReader;

    public ApplicationConfigurationCacheReader(ConfigurationReader defaultConfigurationReader) {
        this.defaultConfigurationReader = defaultConfigurationReader;
    }

    public SAML2ConfigurationJPaaSImpl readValue(String tenantId, SAML2ConfigurationJPaaSImpl currentValue) {
        try {
            if (this.isDefaultTenantId(tenantId)) {
                return this.readDefaultSamlConfiguration();
            }
            logger.debug("Entering readValue with tenantId {} and current value {}", (Object)tenantId, (Object)currentValue);
            ConfigurationReader configurationReader = this.createConfigurationReader(tenantId);
            String configuration = configurationReader.read();
            if (configuration == null) {
                logger.debug("Trust configuration was not found, the default one will be used.");
                return this.readDefaultSamlConfiguration();
            }
            return this.toSamlConfiguration(configuration);
        }
        catch (IOException exception) {
            logger.error("Failed to retrieve the configuration from Domain DB, so the cached one will be used.", (Throwable)exception);
            return currentValue;
        }
    }

    private boolean isDefaultTenantId(String tenantId) {
        return "default_tenant_id".equals(tenantId);
    }

    ConfigurationReader createConfigurationReader(String tenantId) {
        return ConfigurationReaderFactory.createApplicationConfigurationReader(tenantId);
    }

    private SAML2ConfigurationJPaaSImpl readDefaultSamlConfiguration() throws IOException {
        SAML2Configuration saml2Configuration = ConfigParser.parseSAML2Configuration(this.defaultConfigurationReader.read());
        return new SAML2ConfigurationJPaaSImpl(saml2Configuration);
    }

    private SAML2ConfigurationJPaaSImpl toSamlConfiguration(String configuration) throws IOException {
        SAML2Configuration saml2Configuration = ConfigParser.parseSAML2Configuration(configuration);
        return new SAML2ConfigurationJPaaSImpl(saml2Configuration, this.readDefaultSamlConfiguration());
    }
}

