/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service.cfg.json;

import com.sap.core.jpaas.security.saml2.service.cfg.json.JPaaSSerializedName;
import com.sap.security.saml2.commons.Attribute;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertionRule {
    private static final Logger logger = LoggerFactory.getLogger(AssertionRule.class);
    @JPaaSSerializedName(value="assertion.attribute")
    private String assertionAttribute;
    private String operation;
    private String value;

    public String getAssertionAttribute() {
        return this.assertionAttribute;
    }

    public void setAssertionAttribute(String assertionAttribute) {
        this.assertionAttribute = assertionAttribute;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSatisfied(Map<String, Attribute> assertionAttributes) {
        boolean result = false;
        if (logger.isDebugEnabled()) {
            logger.debug("Enter isSatisfied method; operation {}, attribute {}, value {}", new Object[]{this.operation, this.assertionAttribute, this.value});
        }
        if (this.assertionAttribute != null && ("equals".equals(this.operation) || "regexp".equals(this.operation))) {
            Attribute attr = assertionAttributes.get(this.assertionAttribute);
            if (attr != null) {
                HashSet values = new HashSet();
                values.addAll(attr.getValues());
                if (logger.isDebugEnabled()) {
                    logger.debug("Assertion attribute found; Values: ", values);
                }
                if ("regexp".equals(this.operation)) {
                    if (this.value != null) {
                        try {
                            Pattern pattern = Pattern.compile(this.value);
                            for (String attValue : values) {
                                Matcher matcher = pattern.matcher(attValue);
                                if (!matcher.find()) continue;
                                result = true;
                                break;
                            }
                        }
                        catch (PatternSyntaxException exp) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("The regular expresion " + this.value + " has syntax error.", (Throwable)exp);
                            }
                            result = false;
                        }
                    }
                } else if ("equals".equals(this.operation) && this.value != null && values.contains(this.value)) {
                    result = true;
                }
            } else if (this.value == null) {
                result = true;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Exit isSatisfied method; result {}", (Object)result);
        }
        return result;
    }

    public String toString() {
        return "AssertionRule [assertionAttribute=" + this.assertionAttribute + ", operation=" + this.operation + ", value=" + this.value + "]";
    }
}

