/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service.cfg.readers;

import com.sap.core.jpaas.security.saml2.service.cfg.readers.ConfigurationReader;
import com.sap.core.jpaas.security.saml2.service.cfg.readers.DomainDBConfigurationReader;
import com.sap.core.jpaas.security.saml2.service.cfg.readers.FileSystemConfigurationReader;

public class ConfigurationReaderFactory {
    private static final String SAML2_CONFIGURATION_PATH = "rest/configuration/tenant/%s/saml2/saml2_cfg.json";
    private static final String SAML2_ADMIN_CONFIGURATION_PATH = "rest/configuration/tenant/%s/saml2_admin/saml2_cfg.json";

    public static ConfigurationReader createDefaultConfigurationReader() {
        return FileSystemConfigurationReader.getInstance();
    }

    public static ConfigurationReader createAdminConfigurationReader(String tenantId) {
        return new DomainDBConfigurationReader(tenantId, String.format(SAML2_ADMIN_CONFIGURATION_PATH, tenantId));
    }

    public static ConfigurationReader createApplicationConfigurationReader(String tenantId) {
        return new DomainDBConfigurationReader(tenantId, String.format(SAML2_CONFIGURATION_PATH, tenantId));
    }
}

