/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service.cfg.readers;

import com.sap.core.jpaas.security.saml2.service.cfg.ConfigurationLogger;
import com.sap.core.jpaas.security.saml2.service.cfg.json.ConfigurationData;
import com.sap.core.jpaas.security.saml2.service.cfg.readers.ConfigurationReader;
import com.sap.core.jpaas.security.utils.AuditLogMode;
import com.sap.core.jpaas.security.utils.connection.Request;
import com.sap.core.jpaas.security.utils.connection.Response;
import com.sap.core.jpaas.security.utils.connection.impl.DomainDBConnection;
import com.sap.core.jpaas.security.utils.connection.impl.URLRequest;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DomainDBConfigurationReader
implements ConfigurationReader {
    private static final Logger logger = LoggerFactory.getLogger(DomainDBConfigurationReader.class);
    private String path;
    private String tenantId;

    public DomainDBConfigurationReader(String tenantId, String path) {
        this.tenantId = tenantId;
        this.path = path;
    }

    @Override
    public String read() throws IOException {
        Response response = null;
        try {
            DomainDBConnection connection = this.createConnection();
            URLRequest request = this.createRequest();
            logger.debug("Retrieving trust configuration for tenant {} with request {}", (Object)this.tenantId, (Object)request);
            response = connection.execute((Request)request);
            if (response.is(404)) {
                logger.debug("Trust configuration for tenant {} not found.");
                return null;
            }
            if (response.isNotOK()) {
                throw new IOException("Error while reading the trust configuration from domain DB for tenant " + this.tenantId + ". Response code: " + response.getStatus());
            }
            String samlConfiguration = this.extractConfigurationFromRawData(response.asString());
            ConfigurationLogger.debug(this.tenantId, samlConfiguration);
            String string = samlConfiguration;
            return string;
        }
        finally {
            if (response != null) {
                response.consume();
            }
        }
    }

    DomainDBConnection createConnection() {
        return new DomainDBConnection();
    }

    private URLRequest createRequest() {
        return (URLRequest)new URLRequest.Builder().withPath(this.path).withGETMethod().withAuditLog(AuditLogMode.READ).build();
    }

    String extractConfigurationFromRawData(String rawConfigurationData) {
        return ConfigurationData.extractContentFromConfigData(rawConfigurationData);
    }
}

