/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.service.cfg.readers;

import com.sap.core.jpaas.security.saml2.service.SAML2JPaaSConstants;
import com.sap.core.jpaas.security.saml2.service.cfg.ConfigurationLogger;
import com.sap.core.jpaas.security.saml2.service.cfg.readers.ConfigurationReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileSystemConfigurationReader
implements ConfigurationReader {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemConfigurationReader.class);
    private static final String UTF_8 = "UTF-8";
    private static final int BUFFER_SIZE = 1024;
    private static final FileSystemConfigurationReader INSTANCE = new FileSystemConfigurationReader();
    private static final File SAML_DEFAULT_CONFIGURATION_FILE = new File(String.valueOf(SAML2JPaaSConstants.CONFIG_DIR) + File.separator + "saml2_cfg.json");
    private long lastReadingTimeInMillis;
    private String lastConfigurationValue;

    private FileSystemConfigurationReader() {
    }

    public static FileSystemConfigurationReader getInstance() {
        return INSTANCE;
    }

    @Override
    public String read() throws IOException {
        if (this.lastConfigurationValue == null || this.isConfigurationUpdatedSinceLastRead()) {
            logger.debug("Configuration has changed since last reading, so it will be read again.");
            this.lastReadingTimeInMillis = System.currentTimeMillis();
            this.lastConfigurationValue = this.readConfigurationAsString();
            ConfigurationLogger.debugLocalConfiguration(this.lastConfigurationValue);
        }
        return this.lastConfigurationValue;
    }

    private boolean isConfigurationUpdatedSinceLastRead() throws IOException {
        FileTime lastModifiedTime = Files.getLastModifiedTime(SAML_DEFAULT_CONFIGURATION_FILE.toPath(), new LinkOption[0]);
        logger.debug("Last modification of saml configuration: [{}], last reading of saml configuration: [{}].", (Object)lastModifiedTime.toMillis(), (Object)this.lastReadingTimeInMillis);
        return lastModifiedTime.toMillis() + 1001L > this.lastReadingTimeInMillis;
    }

    private String readConfigurationAsString() throws FileNotFoundException, IOException, UnsupportedEncodingException {
        try (BufferedInputStream input = null;){
            byte[] buffer = new byte[1024];
            StringBuilder content = new StringBuilder();
            input = new BufferedInputStream(new FileInputStream(SAML_DEFAULT_CONFIGURATION_FILE));
            int bytesRead = -1;
            while ((bytesRead = input.read(buffer, 0, 1024)) != -1) {
                content.append(new String(buffer, 0, bytesRead, UTF_8));
            }
            String string = content.toString();
            return string;
        }
    }
}

