/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.ext;

import com.sap.conn.jco.ext.ClientPassportManager;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.MessageServerDataProvider;
import com.sap.conn.jco.ext.PasswordChangeHandler;
import com.sap.conn.jco.ext.ServerDataProvider;
import com.sap.conn.jco.ext.ServerPassportManager;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import com.sap.conn.jco.ext.TenantProvider;
import java.lang.reflect.Method;

public abstract class Environment {
    private static boolean sapJ2EE = false;
    private static boolean jstartup = false;
    private static boolean eclipse = false;
    private static boolean standalone = false;
    private static boolean neo = false;
    private static Environment self = null;
    private static String IMPLEMENTATION = "com.sap.conn.jco.rt.RuntimeEnvironment";

    protected Environment() {
    }

    protected abstract void setDestinationDataProvider(DestinationDataProvider var1);

    protected abstract void removeDestinationDataProvider(DestinationDataProvider var1);

    protected abstract boolean hasDestinationDataProviderBeenRegistered();

    protected abstract void setServerDataProvider(ServerDataProvider var1);

    protected abstract void removeServerDataProvider(ServerDataProvider var1);

    protected abstract boolean hasServerDataProviderBeenRegistered();

    protected abstract void setMessageServerDataProvider(MessageServerDataProvider var1);

    protected abstract void removeMessageServerDataProvider(MessageServerDataProvider var1);

    protected abstract boolean hasMessageServerDataProviderBeenRegistered();

    protected abstract void setSessionReferenceProvider(SessionReferenceProvider var1);

    protected abstract void removeSessionReferenceProvider(SessionReferenceProvider var1);

    protected abstract boolean hasSessionReferenceProviderBeenRegistered();

    protected abstract void setTenantProvider(TenantProvider var1);

    protected abstract void removeTenantProvider(TenantProvider var1);

    protected abstract boolean hasTenantProviderBeenRegistered();

    protected abstract void setPasswordChangeHandler(PasswordChangeHandler var1);

    protected abstract void removePasswordChangeHandler(PasswordChangeHandler var1);

    protected abstract boolean hasPasswordChangeHandlerBeenRegistered();

    protected abstract void setClientPassportManager(ClientPassportManager var1);

    protected abstract void removeClientPassportManager(ClientPassportManager var1);

    protected abstract boolean hasClientPassportManagerBeenRegistered();

    protected abstract void setServerPassportManager(ServerPassportManager var1);

    protected abstract void removeServerPassportManager(ServerPassportManager var1);

    protected abstract boolean hasServerPassportManagerBeenRegistered();

    private static Environment getInstance() {
        if (self == null) {
            if (Environment.inJTS()) {
                try {
                    Class<?> serviceManagerClass = Class.forName("com.sap.vmc.service.core.ServiceManager");
                    Method loadLibraryMethod = serviceManagerClass.getMethod("loadLibrary", String.class);
                    loadLibraryMethod.invoke(null, "JCo");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                self = (Environment)Class.forName(IMPLEMENTATION).newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return self;
    }

    private static boolean isNeo() {
        boolean ret = false;
        try {
            Class.forName("com.sap.conn.jco.rt.neo.NeoRuntimeFactory");
            ret = true;
            try {
                Class.forName("com.sap.conn.jco.rt.JCoJ2EERuntime");
                ret = false;
            }
            catch (Throwable t) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static final boolean inSAPVM() {
        return false;
    }

    public static final boolean inJTS() {
        return false;
    }

    public static final boolean inDW() {
        return false;
    }

    public static final boolean inDWJ() {
        return false;
    }

    public static final boolean inJStartup() {
        return jstartup;
    }

    public static final boolean inSAPJ2EE() {
        return sapJ2EE;
    }

    public static final boolean inStandalone() {
        return standalone;
    }

    public static final boolean inEclipsePlugin() {
        return eclipse;
    }

    public static final boolean inNeo() {
        return neo;
    }

    public static void registerDestinationDataProvider(DestinationDataProvider provider) {
        Environment.getInstance().setDestinationDataProvider(provider);
    }

    public static void unregisterDestinationDataProvider(DestinationDataProvider provider) {
        Environment.getInstance().removeDestinationDataProvider(provider);
    }

    public static void registerServerDataProvider(ServerDataProvider provider) {
        Environment.getInstance().setServerDataProvider(provider);
    }

    public static void unregisterServerDataProvider(ServerDataProvider provider) {
        Environment.getInstance().removeServerDataProvider(provider);
    }

    public static void registerMessageServerDataProvider(MessageServerDataProvider provider) {
        Environment.getInstance().setMessageServerDataProvider(provider);
    }

    public static void unregisterMessageServerDataProvider(MessageServerDataProvider provider) {
        Environment.getInstance().removeMessageServerDataProvider(provider);
    }

    public static void registerSessionReferenceProvider(SessionReferenceProvider provider) {
        Environment.getInstance().setSessionReferenceProvider(provider);
    }

    public static void unregisterSessionReferenceProvider(SessionReferenceProvider provider) {
        Environment.getInstance().removeSessionReferenceProvider(provider);
    }

    public static void registerTenantProvider(TenantProvider provider) {
        Environment.getInstance().setTenantProvider(provider);
    }

    public static void unregisterTenantProvider(TenantProvider provider) {
        Environment.getInstance().removeTenantProvider(provider);
    }

    public static void registerClientPassportManager(ClientPassportManager passportManager) {
        Environment.getInstance().setClientPassportManager(passportManager);
    }

    public static void unregisterClientPassportManager(ClientPassportManager passportManager) {
        Environment.getInstance().removeClientPassportManager(passportManager);
    }

    public static void registerServerPassportManager(ServerPassportManager passportManager) {
        Environment.getInstance().setServerPassportManager(passportManager);
    }

    public static void unregisterServePassportManager(ServerPassportManager passportManager) {
        Environment.getInstance().removeServerPassportManager(passportManager);
    }

    public static void registerPasswordChangeHandler(PasswordChangeHandler passwordChangeHandler) {
        Environment.getInstance().setPasswordChangeHandler(passwordChangeHandler);
    }

    public static void unregisterPasswordChangeHandler(PasswordChangeHandler passwordChangeHandler) {
        Environment.getInstance().removePasswordChangeHandler(passwordChangeHandler);
    }

    public static boolean isDestinationDataProviderRegistered() {
        return Environment.getInstance().hasDestinationDataProviderBeenRegistered();
    }

    public static boolean isServerDataProviderRegistered() {
        return Environment.getInstance().hasServerDataProviderBeenRegistered();
    }

    public static boolean isMessageServerDataProviderRegistered() {
        return Environment.getInstance().hasMessageServerDataProviderBeenRegistered();
    }

    public static boolean isSessionReferenceProviderRegistered() {
        return Environment.getInstance().hasSessionReferenceProviderBeenRegistered();
    }

    public static boolean isTenantProviderRegistered() {
        return Environment.getInstance().hasTenantProviderBeenRegistered();
    }

    public static boolean isClientPassportManagerRegistered() {
        return Environment.getInstance().hasClientPassportManagerBeenRegistered();
    }

    public static boolean isServerPassportManagerRegistered() {
        return Environment.getInstance().hasServerPassportManagerBeenRegistered();
    }

    public static boolean isPasswordChangeHandlerRegistered() {
        return Environment.getInstance().hasPasswordChangeHandlerBeenRegistered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            Class<?> jStartupFrameworkClass = Class.forName("com.sap.bc.proj.jstartup.JStartupFramework");
            jstartup = System.getProperty("jstartup.mode") != null;
            Method getParamM = jStartupFrameworkClass.getMethod("getParam", String.class);
            String sapSystemName = (String)getParamM.invoke(null, "SAPSYSTEMNAME");
            sapJ2EE = sapSystemName != null && sapSystemName.length() > 0;
        }
        catch (Throwable t) {
            sapJ2EE = false;
        }
        standalone = !sapJ2EE;
        eclipse = false;
        if (standalone) {
            ClassLoader cl = Environment.class.getClassLoader();
            while (cl != null && !eclipse) {
                try {
                    if (!cl.getClass().getName().startsWith("org.eclipse.osgi")) continue;
                    eclipse = true;
                }
                catch (Throwable throwable) {}
                continue;
                finally {
                    cl = cl.getParent();
                }
            }
            neo = Environment.isNeo();
        }
    }
}

