/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.util.AboutDialog;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class About
extends AboutDialog {
    private static final String NOT_FOUND = "not found";
    private static final String UNKNOWN = "unknown";

    public About() {
        super("SAP Java Connector");
        String jar_path = NOT_FOUND;
        String lib_path = NOT_FOUND;
        String jco_version = "3.1.1.22 (2018-09-28) for SAP Cloud Platform";
        String jco_middleware = UNKNOWN;
        String jco_lib_version = UNKNOWN;
        String jco_error = null;
        try {
            jar_path = this.getOwnFilePath();
            JCoRuntime rt = JCoRuntimeFactory.getRuntime();
            jco_version = rt.getVersion();
            jco_middleware = rt.getMiddlewarePropertyValue("jco.middleware.name") + " " + rt.getMiddlewarePropertyValue("jco.middleware.version");
            jco_lib_version = rt.getMiddlewarePropertyValue("jco.middleware.native_layer_version");
            lib_path = rt.getMiddlewarePropertyValue("jco.middleware.native_layer_path");
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            jco_error = sw.toString();
            System.out.println(jco_error);
        }
        AboutDialog.Section section = new AboutDialog.Section("Versions");
        section.addEntry("JCo API", jco_version);
        section.addEntry("JCo middleware", jco_middleware);
        section.addEntry("JCo library", jco_lib_version);
        this.addSection(section);
        section = new AboutDialog.Section("Library Paths");
        section.addEntry("JCo archive", jar_path);
        section.addEntry("JCo library", lib_path);
        this.addSection(section);
        if (jco_error != null) {
            section = new AboutDialog.Section("Initialization");
            section.addEntry("JCo error", jco_error);
            this.addSection(section);
        }
    }

    public static void main(String[] args) {
        new About().show(args);
    }

    public static String getAboutOutputAsString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        new About().printTo(pw);
        pw.close();
        return sw.getBuffer().toString();
    }

    public static boolean isNativeLayerAvailable() {
        try {
            JCoRuntime rt = JCoRuntimeFactory.getRuntime();
            String middleware_native_version = rt.getMiddlewarePropertyValue("jco.middleware.native_layer_version");
            return middleware_native_version != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

