/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.ConversionException;
import com.sap.conn.jco.JCoAbapObject;
import com.sap.conn.jco.JCoClassMetaData;
import com.sap.conn.jco.JCoExtendedFieldMetaData;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFieldIterator;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRequest;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultAbapObject;
import com.sap.conn.jco.rt.DefaultFieldIterator;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.rt.XMLWriter;
import com.sap.conn.jco.rt.json.JSonParser;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.UtcTypes;
import com.sap.i18n.decfloat.DecFloat;
import com.sap.i18n.decfloat.DecFloatType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class AbstractRequestResponse
implements JCoRecord,
Cloneable {
    static final long serialVersionUID = 3000120080918L;
    String name;
    private int type;
    private JCoParameterList oneway;
    private JCoParameterList changing;
    private JCoParameterList tables;
    private AbapException[] exceptions;
    private JCoListMetaData fullList = null;
    private HashMap<String, Integer> hashOfIndices = null;
    int size = 0;
    protected JCoParameterList[] mapList;
    protected int[] mapIndex;

    protected AbstractRequestResponse(String name, int type, JCoParameterList oneway, JCoParameterList changing, JCoParameterList tables, AbapException[] exceptions) {
        this.name = name;
        this.type = type;
        int changingOffset = 0;
        int tablesOffset = 0;
        this.oneway = oneway;
        this.changing = changing;
        this.tables = tables;
        this.exceptions = exceptions;
        changingOffset = oneway == null ? 0 : oneway.getListMetaData().getFieldCount();
        tablesOffset = changingOffset + (changing == null ? 0 : changing.getListMetaData().getFieldCount());
        this.size = tablesOffset + (tables == null ? 0 : tables.getListMetaData().getFieldCount());
        this.mapList = new JCoParameterList[this.size];
        this.mapIndex = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            if (i < changingOffset) {
                this.mapList[i] = oneway;
                this.mapIndex[i] = i;
                continue;
            }
            if (i < tablesOffset) {
                this.mapList[i] = changing;
                this.mapIndex[i] = i - changingOffset;
                continue;
            }
            this.mapList[i] = tables;
            this.mapIndex[i] = i - tablesOffset;
        }
    }

    int getMappedIndex(int index) {
        return this.mapIndex[index];
    }

    JCoParameterList getMappedList(int index) {
        return this.mapList[index];
    }

    protected final void checkIndex(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(150).append("Index [").append(index).append("] out of bounds.").append(this.name).append(" has").append(this.size).append(" fields.").toString());
        }
    }

    protected final void rebuildIndicies() {
        if (this.hashOfIndices == null || this.hashOfIndices.size() < this.size) {
            int hashMapSize = this.size < 4 ? 5 : (this.size < 8 ? 11 : (this.size < 21 ? 29 : (this.size < 35 ? 47 : 89)));
            HashMap<String, Integer> indices = new HashMap<String, Integer>(hashMapSize);
            int i = this.size;
            while (--i >= 0) {
                indices.put(this.mapList[i].getMetaData().getName(this.mapIndex[i]), new Integer(i));
            }
            this.hashOfIndices = indices;
        }
    }

    public AbstractRequestResponse clone() {
        AbstractRequestResponse clone = null;
        try {
            clone = (AbstractRequestResponse)super.clone();
            clone.name = this.name;
            clone.type = this.type;
            clone.size = this.size;
            if (this.oneway != null) {
                clone.oneway = (JCoParameterList)this.oneway.clone();
            }
            if (this.changing != null) {
                clone.changing = (JCoParameterList)this.changing.clone();
            }
            if (this.tables != null) {
                clone.tables = (JCoParameterList)this.tables.clone();
            }
            if (this.exceptions != null) {
                clone.exceptions = this.exceptions;
            }
            if (this.hashOfIndices != null) {
                clone.hashOfIndices = (HashMap)this.hashOfIndices.clone();
            }
            clone.mapIndex = (int[])this.mapIndex.clone();
            clone.mapList = (JCoParameterList[])this.mapList.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractRequestResponse) {
            boolean equals;
            AbstractRequestResponse r = (AbstractRequestResponse)obj;
            boolean bl = this.oneway != null ? this.oneway.equals(r.oneway) : (equals = r.oneway == null);
            if (equals) {
                boolean bl2 = this.changing != null ? this.changing.equals(r.changing) : (equals = r.changing == null);
            }
            if (equals) {
                equals = this.tables != null ? this.tables.equals(r.tables) : r.tables == null;
            }
            return equals;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.name.hashCode();
        if (this.oneway != null) {
            hashCode = 31 * hashCode + this.oneway.hashCode();
        }
        if (this.changing != null) {
            hashCode = 31 * hashCode + this.changing.hashCode();
        }
        if (this.tables != null) {
            hashCode = 31 * hashCode + this.tables.hashCode();
        }
        return hashCode;
    }

    public String getName() {
        return this.name;
    }

    public final int indexOf(String fieldName) {
        this.rebuildIndicies();
        Integer idx = this.hashOfIndices.get(fieldName);
        if (idx != null) {
            return idx;
        }
        throw new IllegalArgumentException(new StringBuilder(150).append("Field ").append(fieldName).append(" not a member of ").append(this instanceof JCoRequest ? "Request" : "Response").toString());
    }

    public JCoListMetaData getListMetaData() {
        if (this.fullList == null) {
            this.fullList = new ResponseRequestMetadata();
        }
        return this.fullList;
    }

    public JCoMetaData getMetaData() {
        return this.getListMetaData();
    }

    public boolean isActive(int index) {
        this.checkIndex(index);
        return this.mapList[index].isActive(this.mapIndex[index]);
    }

    public boolean isActive(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].isActive(this.mapIndex[index]);
    }

    public void setActive(int index, boolean active) {
        this.checkIndex(index);
        this.mapList[index].setActive(this.mapIndex[index], active);
    }

    public void setActive(String fieldName, boolean active) {
        int index = this.indexOf(fieldName);
        this.mapList[index].setActive(this.mapIndex[index], active);
    }

    public void clear() {
        if (this.oneway != null) {
            this.oneway.clear();
        }
        if (this.changing != null) {
            this.changing.clear();
        }
        if (this.tables != null) {
            this.tables.clear();
        }
    }

    public int copyFrom(JCoRecord source) {
        if (source == null) {
            return 0;
        }
        JCoMetaData smd = source.getMetaData();
        JCoMetaData dmd = this.getMetaData();
        if (source instanceof AbstractRequestResponse) {
            AbstractRequestResponse sourceRR = (AbstractRequestResponse)source;
            if (smd.equals(dmd)) {
                if (this.oneway != null) {
                    this.oneway.copyFrom((JCoRecord)sourceRR.oneway);
                }
                if (this.changing != null) {
                    this.changing.copyFrom((JCoRecord)sourceRR.changing);
                }
                if (this.tables != null) {
                    this.tables.copyFrom((JCoRecord)sourceRR.tables);
                }
            }
            return smd.getFieldCount();
        }
        char[] onewayDataSave = null;
        char[][] onewayTableDataRowsSave = null;
        Object[] onewayOdataSave = null;
        byte[] onewayFlagsSave = null;
        if (this.oneway != null) {
            onewayDataSave = ((DefaultParameterList)this.oneway).data;
            onewayTableDataRowsSave = ((DefaultParameterList)this.oneway).tableDataRows;
            onewayOdataSave = ((DefaultParameterList)this.oneway).odata;
            onewayFlagsSave = ((DefaultParameterList)this.oneway).flags;
        }
        char[] changingDataSave = null;
        char[][] changingTableDataRowsSave = null;
        Object[] changingOdataSave = null;
        byte[] changingFlagsSave = null;
        if (this.changing != null) {
            changingDataSave = ((DefaultParameterList)this.changing).data;
            changingTableDataRowsSave = ((DefaultParameterList)this.changing).tableDataRows;
            changingOdataSave = ((DefaultParameterList)this.changing).odata;
            changingFlagsSave = ((DefaultParameterList)this.changing).flags;
        }
        char[] tablesDataSave = null;
        char[][] tablesTableDataRowsSave = null;
        Object[] tablesOdataSave = null;
        byte[] tablesFlagsSave = null;
        if (this.tables != null) {
            tablesDataSave = ((DefaultParameterList)this.tables).data;
            tablesTableDataRowsSave = ((DefaultParameterList)this.tables).tableDataRows;
            tablesOdataSave = ((DefaultParameterList)this.tables).odata;
            tablesFlagsSave = ((DefaultParameterList)this.tables).flags;
        }
        try {
            int didx = 0;
            int sidx = 0;
            int copied = 0;
            block11: for (sidx = 0; sidx < smd.getFieldCount(); ++sidx) {
                String fieldName = smd.getName(sidx);
                didx = this.indexOf(fieldName);
                if (dmd.getType(didx) != smd.getType(sidx) || dmd.getRecordTypeName(didx) != null && !dmd.getRecordTypeName(didx).equals(smd.getRecordTypeName(sidx))) continue;
                ++copied;
                switch (dmd.getType(didx)) {
                    case 0: 
                    case 2: 
                    case 6: 
                    case 29: {
                        this.setValue(didx, source.getString(sidx));
                        continue block11;
                    }
                    case 4: 
                    case 30: {
                        this.setValue(didx, source.getByteArray(sidx));
                        continue block11;
                    }
                    case 8: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        this.setValue(didx, source.getInt(sidx));
                        continue block11;
                    }
                    case 9: 
                    case 10: 
                    case 58: 
                    case 59: {
                        this.setValue(didx, source.getShort(sidx));
                        continue block11;
                    }
                    case 40: 
                    case 51: 
                    case 52: 
                    case 53: {
                        this.setValue(didx, source.getLong(sidx));
                        continue block11;
                    }
                    case 17: {
                        JCoStructure s = source.getStructure(sidx);
                        this.setValue(didx, (JCoStructure)(s == null ? s : ((DefaultStructure)s).clone()));
                        continue block11;
                    }
                    case 99: {
                        JCoTable t = source.getTable(sidx);
                        this.setValue(didx, (JCoTable)(t == null ? t : ((DefaultTable)t).clone()));
                        continue block11;
                    }
                    default: {
                        this.setValue(didx, source.getValue(sidx));
                    }
                }
            }
            return copied;
        }
        catch (Throwable t) {
            if (this.oneway != null) {
                ((DefaultParameterList)this.oneway).data = onewayDataSave;
                ((DefaultParameterList)this.oneway).tableDataRows = onewayTableDataRowsSave;
                ((DefaultParameterList)this.oneway).odata = onewayOdataSave;
                ((DefaultParameterList)this.oneway).flags = onewayFlagsSave;
            }
            if (this.changing != null) {
                ((DefaultParameterList)this.changing).data = changingDataSave;
                ((DefaultParameterList)this.changing).tableDataRows = changingTableDataRowsSave;
                ((DefaultParameterList)this.changing).odata = changingOdataSave;
                ((DefaultParameterList)this.changing).flags = changingFlagsSave;
            }
            if (this.tables != null) {
                ((DefaultParameterList)this.tables).data = tablesDataSave;
                ((DefaultParameterList)this.tables).tableDataRows = tablesTableDataRowsSave;
                ((DefaultParameterList)this.tables).odata = tablesOdataSave;
                ((DefaultParameterList)this.tables).flags = tablesFlagsSave;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Throwable in Request/Response copyFrom: " + t.toString(), t);
        }
    }

    public int getFieldCount() {
        return this.size;
    }

    public JCoField getField(int index) {
        this.checkIndex(index);
        return this.mapList[index].getField(this.mapIndex[index]);
    }

    public Object getValue(int index) {
        this.checkIndex(index);
        return this.mapList[index].getValue(this.mapIndex[index]);
    }

    public String getString(int index) {
        this.checkIndex(index);
        return this.mapList[index].getString(this.mapIndex[index]);
    }

    public char getChar(int index) {
        this.checkIndex(index);
        return this.mapList[index].getChar(this.mapIndex[index]);
    }

    public byte getByte(int index) {
        this.checkIndex(index);
        return this.mapList[index].getByte(this.mapIndex[index]);
    }

    public byte getByte(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getByte(this.mapIndex[index]);
    }

    public float getFloat(int index) {
        this.checkIndex(index);
        return this.mapList[index].getFloat(this.mapIndex[index]);
    }

    public float getFloat(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getFloat(this.mapIndex[index]);
    }

    public short getShort(int index) {
        this.checkIndex(index);
        return this.mapList[index].getShort(this.mapIndex[index]);
    }

    public int getInt(int index) {
        this.checkIndex(index);
        return this.mapList[index].getInt(this.mapIndex[index]);
    }

    public long getLong(int index) {
        this.checkIndex(index);
        return this.mapList[index].getLong(this.mapIndex[index]);
    }

    public BigInteger getBigInteger(int index) {
        this.checkIndex(index);
        return this.mapList[index].getBigInteger(this.mapIndex[index]);
    }

    public double getDouble(int index) {
        this.checkIndex(index);
        return this.mapList[index].getDouble(this.mapIndex[index]);
    }

    public BigDecimal getBigDecimal(int index) {
        this.checkIndex(index);
        return this.mapList[index].getBigDecimal(this.mapIndex[index]);
    }

    public Date getDate(int index) {
        this.checkIndex(index);
        return this.mapList[index].getDate(this.mapIndex[index]);
    }

    public Date getTime(int index) {
        this.checkIndex(index);
        return this.mapList[index].getTime(this.mapIndex[index]);
    }

    public byte[] getByteArray(int index) {
        this.checkIndex(index);
        return this.mapList[index].getByteArray(this.mapIndex[index]);
    }

    public char[] getCharArray(int index) {
        this.checkIndex(index);
        return this.mapList[index].getCharArray(this.mapIndex[index]);
    }

    public InputStream getBinaryStream(int index) {
        this.checkIndex(index);
        return this.mapList[index].getBinaryStream(this.mapIndex[index]);
    }

    public Reader getCharacterStream(int index) {
        this.checkIndex(index);
        return this.mapList[index].getCharacterStream(this.mapIndex[index]);
    }

    public JCoTable getTable(int index) {
        this.checkIndex(index);
        return this.mapList[index].getTable(this.mapIndex[index]);
    }

    public JCoStructure getStructure(int index) {
        this.checkIndex(index);
        return this.mapList[index].getStructure(this.mapIndex[index]);
    }

    public String toXML(int index) {
        this.checkIndex(index);
        return this.mapList[index].toXML(this.mapIndex[index]);
    }

    public String toXML(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getString(this.mapIndex[index]);
    }

    public String toXML() {
        return XMLWriter.createXMLDocument(this, this.name);
    }

    public String toJSON() {
        StringWriter sw = new StringWriter();
        try {
            this.toJSON(sw);
        }
        catch (IOException ioe) {
            Trace.fireTraceCritical("[JCoAPI] JCoRecord.toJSON(" + this.getMetaData().getName() + ") throws " + ioe.toString());
        }
        return sw.toString();
    }

    private void escapeJSONvalue(Writer writer, String value) throws IOException {
        block12: for (int i = 0; i < value.length(); ++i) {
            char currentChar = value.charAt(i);
            switch (currentChar) {
                case '\"': {
                    writer.write("\\\"");
                    continue block12;
                }
                case '\b': {
                    writer.write("\\b");
                    continue block12;
                }
                case '\r': {
                    writer.write("\\r");
                    continue block12;
                }
                case '\n': {
                    writer.write("\\n");
                    continue block12;
                }
                case '\f': {
                    writer.write("\\f");
                    continue block12;
                }
                case '\t': {
                    writer.write("\\t");
                    continue block12;
                }
                case '\\': {
                    writer.write("\\\\");
                    continue block12;
                }
                case '/': {
                    writer.write("\\/");
                    continue block12;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': {
                    writer.write("\\u000");
                    writer.write(Integer.toHexString(currentChar));
                    continue block12;
                }
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    writer.write("\\u00");
                    writer.write(Integer.toHexString(currentChar));
                    continue block12;
                }
                default: {
                    writer.write(currentChar);
                }
            }
        }
    }

    public void toJSON(Writer writer) throws IOException {
        writer.write(123);
        JCoMetaData metaData = this.getMetaData();
        block8: for (int i = 0; i < metaData.getFieldCount(); ++i) {
            if (i > 0) {
                writer.write(44);
            }
            int typeId = metaData.getType(i);
            writer.write(34);
            writer.write(metaData.getName(i));
            writer.write("\":");
            switch (typeId) {
                case 0: 
                case 1: 
                case 3: 
                case 29: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: {
                    writer.write(34);
                    this.escapeJSONvalue(writer, this.mapList[i].getString(this.mapIndex[i]));
                    writer.write(34);
                    continue block8;
                }
                case 2: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 23: 
                case 24: 
                case 40: {
                    writer.write(this.mapList[i].getString(this.mapIndex[i]));
                    continue block8;
                }
                case 4: 
                case 30: {
                    writer.write(34);
                    writer.write(Codecs.Base64.encodeAsCharArray(this.mapList[i].getByteArray(this.mapIndex[i])));
                    writer.write(34);
                    continue block8;
                }
                case 17: {
                    this.mapList[i].getStructure(this.mapIndex[i]).toJSON(writer);
                    continue block8;
                }
                case 99: {
                    this.mapList[i].getTable(this.mapIndex[i]).toJSON(writer);
                    continue block8;
                }
                case 16: {
                    JCoAbapObject ao = this.mapList[i].getAbapObject(this.mapIndex[i]);
                    if (ao == null) {
                        writer.append("null");
                        continue block8;
                    }
                    ao.toJSON(writer);
                    continue block8;
                }
                default: {
                    writer.write(34);
                    writer.write(this.mapList[i].getString(this.mapIndex[i]));
                    writer.write(34);
                }
            }
        }
        writer.append('}');
        writer.flush();
    }

    public void fromJSON(Reader reader) {
        JSonParser parser = new JSonParser(reader);
        JCoListMetaData metaData = this.getListMetaData();
        try {
            parser.assertChar('{');
            boolean assumeComma = false;
            while (parser.nextNonBlankChar() != 125) {
                parser.undo();
                if (assumeComma) {
                    parser.assertChar(',');
                }
                this.rebuildIndicies();
                Integer fieldIndex = this.hashOfIndices.get(parser.nextString());
                parser.assertChar(':');
                if (fieldIndex != null) {
                    this.encodeField(parser, fieldIndex, metaData.getType(fieldIndex.intValue()));
                    assumeComma = true;
                    continue;
                }
                assumeComma = parser.skipField();
            }
        }
        catch (IOException e) {
            Trace.fireTraceCritical("[JCoAPI] JCoRecord(AbstractRequestResponse).readValuesFromJSON(" + this.getMetaData().getName() + ") throws " + e.toString());
        }
    }

    public void fromJSON(String data) {
        StringReader reader = new StringReader(data);
        this.fromJSON(reader);
        reader.close();
    }

    private void encodeField(JSonParser parser, int fieldIndex, int typeId) throws IOException {
        switch (typeId) {
            case 0: 
            case 6: 
            case 29: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], parser.nextString());
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], parser.nextIntOrIntString());
                break;
            }
            case 2: 
            case 7: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], parser.nextFloatAsString());
                break;
            }
            case 40: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], parser.nextLongOrLongString());
                break;
            }
            case 23: {
                this.readDecFloat(parser, 8, DecFloatType.DECFLOAT16_BE, fieldIndex);
                break;
            }
            case 24: {
                this.readDecFloat(parser, 16, DecFloatType.DECFLOAT34_BE, fieldIndex);
                break;
            }
            case 1: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], parser.nextString().replaceAll("-", ""));
                break;
            }
            case 3: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], parser.nextString().replaceAll(":", ""));
                break;
            }
            case 4: 
            case 30: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], Codecs.Base64.decode(parser.nextString()));
                break;
            }
            case 54: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], UtcTypes.DtDay.parse(parser.nextString()));
                break;
            }
            case 55: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], UtcTypes.DtWeek.parse(parser.nextString()));
                break;
            }
            case 56: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], UtcTypes.DtMonth.parse(parser.nextString()));
                break;
            }
            case 57: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], UtcTypes.TSecond.parse(parser.nextString()));
                break;
            }
            case 58: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], UtcTypes.TMinute.parse(parser.nextString()));
                break;
            }
            case 59: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], UtcTypes.Cday.parse(parser.nextString()));
                break;
            }
            case 51: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], UtcTypes.UtcLong.parse(parser.nextString()));
                break;
            }
            case 52: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], UtcTypes.UtcSecond.parse(parser.nextString()));
                break;
            }
            case 53: {
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], UtcTypes.UtcMinute.parse(parser.nextString()));
                break;
            }
            case 17: {
                DefaultStructure tmpStruct = ((AbstractRecord)this.mapList[fieldIndex]).getStructure(this.mapIndex[fieldIndex]);
                tmpStruct.readValuesFromJSON(parser);
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], (JCoStructure)tmpStruct);
                break;
            }
            case 99: {
                DefaultTable tmpTable = ((AbstractRecord)this.mapList[fieldIndex]).getTable(this.mapIndex[fieldIndex]);
                tmpTable.readValuesFromJSON(parser);
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], (JCoTable)tmpTable);
                break;
            }
            case 16: {
                if (parser.nextNonBlankChar() != 123) {
                    parser.undo();
                    parser.assertChar('n');
                    parser.assertChar('u');
                    parser.assertChar('l');
                    parser.assertChar('l');
                    this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], (Object)null);
                    break;
                }
                DefaultAbapObject tmpObj = ((AbstractRecord)this.mapList[fieldIndex]).getAbapObject(this.mapIndex[fieldIndex]);
                parser.undo();
                tmpObj.readValuesFromJSON(parser);
                this.mapList[fieldIndex].setValue(this.mapIndex[fieldIndex], (JCoAbapObject)tmpObj);
                break;
            }
            default: {
                this.setValue(fieldIndex, parser.nextString());
            }
        }
    }

    private void readDecFloat(JSonParser parser, int decFloatLength, DecFloatType type, int index) throws IOException {
        String input = parser.nextFloatAsString();
        byte[] out = new byte[decFloatLength];
        DecFloat.fromString(type, input, out, 0, input.length());
        this.mapList[index].setValue(this.mapIndex[index], DecFloat.toBigDecimal(type, out, 0, decFloatLength));
    }

    public void setValue(int index, String value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public JCoField getField(String fieldName) {
        return this.mapList[this.indexOf(fieldName)].getField(fieldName);
    }

    public String getClassNameOfValue(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getClassNameOfValue(fieldName);
    }

    public Object getValue(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getValue(this.mapIndex[index]);
    }

    public String getString(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getString(this.mapIndex[index]);
    }

    public char getChar(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getChar(this.mapIndex[index]);
    }

    public short getShort(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getShort(this.mapIndex[index]);
    }

    public int getInt(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getInt(this.mapIndex[index]);
    }

    public long getLong(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getLong(this.mapIndex[index]);
    }

    public BigInteger getBigInteger(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getBigInteger(this.mapIndex[index]);
    }

    public double getDouble(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getDouble(this.mapIndex[index]);
    }

    public BigDecimal getBigDecimal(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getBigDecimal(this.mapIndex[index]);
    }

    public Date getDate(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getDate(this.mapIndex[index]);
    }

    public Date getTime(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getTime(this.mapIndex[index]);
    }

    public byte[] getByteArray(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getByteArray(this.mapIndex[index]);
    }

    public char[] getCharArray(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getCharArray(this.mapIndex[index]);
    }

    public InputStream getBinaryStream(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getBinaryStream(this.mapIndex[index]);
    }

    public Reader getCharacterStream(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getCharacterStream(this.mapIndex[index]);
    }

    public JCoTable getTable(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getTable(this.mapIndex[index]);
    }

    public JCoStructure getStructure(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getStructure(this.mapIndex[index]);
    }

    public void setValue(int index, char value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(int index, char[] value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(int index, char[] value, int from, int length) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value, from, length);
    }

    public void setValue(int index, short value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(int index, int value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(int index, long value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(int index, double value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(int index, byte[] value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(int index, JCoStructure value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(int index, JCoTable value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(int index, Object value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(String name, String value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(String name, char[] value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(String name, char[] value, int from, int length) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value, from, length);
    }

    public void setValue(String name, char value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(String name, short value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(String name, int value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(String name, long value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(String name, double value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(int index, float value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(String name, float value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(int index, BigDecimal value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(String name, BigDecimal value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(int index, byte value) {
        this.checkIndex(index);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(String name, byte value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(String name, byte[] value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(String name, JCoStructure value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(String name, JCoTable value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public void setValue(String name, Object value) {
        int index = this.indexOf(name);
        this.mapList[index].setValue(this.mapIndex[index], value);
    }

    public JCoAbapObject getAbapObject(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].getAbapObject(this.mapIndex[index]);
    }

    public JCoAbapObject getAbapObject(int index) {
        this.checkIndex(index);
        return this.mapList[index].getAbapObject(this.mapIndex[index]);
    }

    public void setValue(String fieldName, JCoAbapObject abapObject) {
        int index = this.indexOf(fieldName);
        this.mapList[index].setValue(index, abapObject);
    }

    public void setValue(int index, JCoAbapObject abapObject) {
        this.checkIndex(index);
        this.mapList[index].setValue(index, abapObject);
    }

    public boolean isInitialized(String fieldName) {
        int index = this.indexOf(fieldName);
        return this.mapList[index].isInitialized(this.mapIndex[index]);
    }

    public boolean isInitialized(int index) {
        this.checkIndex(index);
        return this.mapList[index].isInitialized(this.mapIndex[index]);
    }

    public Iterator<JCoField> iterator() {
        return new DefaultFieldIterator(this);
    }

    public JCoFieldIterator getFieldIterator() {
        return new DefaultFieldIterator(this);
    }

    public AbapException[] getExceptionList() {
        return this.exceptions;
    }

    public AbapException getException(String key) {
        if (this.exceptions == null) {
            return null;
        }
        for (int i = 0; i < this.exceptions.length; ++i) {
            if (!this.exceptions[i].getKey().equalsIgnoreCase(key)) continue;
            AbapException ex = this.exceptions[i];
            return new AbapException(ex.getKey(), ex.getMessage() == null ? ex.getKey() : ex.getMessage());
        }
        return null;
    }

    public String toString() {
        int rIdx;
        AbstractRecord r;
        int i;
        int length;
        int index;
        JCoListMetaData metaData = this.getListMetaData();
        StringBuilder buf = new StringBuilder(200);
        int ilength = 0;
        buf.append('|');
        for (index = 0; index < this.size; ++index) {
            switch (metaData.getType(index)) {
                case 17: 
                case 29: 
                case 30: 
                case 99: {
                    length = metaData.getName(index).length();
                    for (i = 0; i < length; ++i) {
                        buf.append('-');
                    }
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    ilength = ((AbstractRecord)this.mapList[index]).metaData.blength[index];
                    for (i = 0; i < ilength; ++i) {
                        buf.append("----");
                    }
                    break;
                }
                default: {
                    ilength = ((AbstractRecord)this.mapList[index]).metaData.blength[index];
                    for (i = 0; i < ilength; ++i) {
                        buf.append('-');
                    }
                }
            }
            buf.append('|');
        }
        String lineString = buf.toString();
        buf.append(JCoRuntime.CRLF);
        buf.append("|");
        buf.append(this.name.toUpperCase(Locale.ENGLISH));
        buf.append(JCoRuntime.CRLF);
        buf.append(lineString);
        buf.append(JCoRuntime.CRLF);
        for (index = 0; index < this.size; ++index) {
            String iname = metaData.getName(index);
            switch (metaData.getType(index)) {
                case 17: 
                case 29: 
                case 30: 
                case 99: {
                    ilength = iname.length();
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    ilength = ((AbstractRecord)this.mapList[index]).metaData.blength[index] * 4;
                    break;
                }
                default: {
                    ilength = ((AbstractRecord)this.mapList[index]).metaData.blength[index];
                }
            }
            if (iname.length() > ilength) {
                iname = iname.substring(0, ilength);
            }
            buf.append("|");
            buf.append(iname);
            length = ilength;
            for (i = iname.length(); i < length; ++i) {
                buf.append(' ');
            }
        }
        buf.append("|" + JCoRuntime.CRLF);
        buf.append(lineString);
        buf.append(JCoRuntime.CRLF);
        buf.append('|');
        for (index = 0; index < this.size; ++index) {
            switch (metaData.getType(index)) {
                case 17: 
                case 29: 
                case 30: 
                case 99: {
                    length = metaData.getName(index).length();
                    for (i = 0; i < length; ++i) {
                        buf.append(' ');
                    }
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    r = (AbstractRecord)this.mapList[index];
                    rIdx = this.mapIndex[index];
                    length = r.metaData.boffset[rIdx] + r.metaData.blength[rIdx];
                    for (i = r.metaData.boffset[rIdx]; i < length; ++i) {
                        buf.append("   ");
                        buf.append(i % 10);
                    }
                    break;
                }
                default: {
                    r = (AbstractRecord)this.mapList[index];
                    rIdx = this.mapIndex[index];
                    length = r.metaData.boffset[rIdx] + r.metaData.blength[rIdx];
                    for (i = r.metaData.boffset[rIdx]; i < length; ++i) {
                        buf.append(i % 10);
                    }
                }
            }
            buf.append('|');
        }
        buf.append(JCoRuntime.CRLF);
        buf.append(lineString);
        buf.append(JCoRuntime.CRLF);
        buf.append('|');
        for (index = 0; index < this.size; ++index) {
            switch (metaData.getType(index)) {
                case 17: 
                case 99: {
                    buf.append(metaData.getName(index));
                    break;
                }
                case 29: 
                case 30: {
                    try {
                        String temp = this.getString(index);
                        ilength = metaData.getName(index).length();
                        if (temp == null) {
                            temp = "null";
                        }
                        if (temp.length() > ilength) {
                            temp = temp.substring(0, ilength);
                        }
                        buf.append(temp);
                        for (int i2 = temp.length(); i2 < ilength; ++i2) {
                            buf.append(' ');
                        }
                        break;
                    }
                    catch (ConversionException ex) {
                        break;
                    }
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    r = (AbstractRecord)this.mapList[index];
                    rIdx = this.mapIndex[index];
                    buf.append(r.decodeHEX(rIdx));
                    break;
                }
                default: {
                    buf.append(this.mapList[index].getString(this.mapIndex[index]));
                }
            }
            buf.append('|');
        }
        buf.append(JCoRuntime.CRLF);
        buf.append(lineString);
        buf.append(JCoRuntime.CRLF);
        return buf.toString();
    }

    public Writer write(int index, Writer writer) throws IOException {
        this.checkIndex(index);
        return this.mapList[index].write(this.mapIndex[index], writer);
    }

    public Writer write(String fieldName, Writer writer) throws IOException {
        int index = this.indexOf(fieldName);
        return this.mapList[index].write(this.mapIndex[index], writer);
    }

    class ResponseRequestMetadata
    implements JCoListMetaData {
        private static final long serialVersionUID = 20050909001L;

        ResponseRequestMetadata() {
        }

        public void add(String pname, int ptype, int nucByteLength, int ucByteLength, int flags) {
            throw new UnsupportedOperationException("MetaData for a JCoRequest or a JCoResponse cannot be modified at all.");
        }

        public void add(String pname, int ptype, JCoRecordMetaData recordMetaData, int flags) {
            throw new UnsupportedOperationException("MetaData for a JCoRequest or a JCoResponse cannot be modified at all.");
        }

        public void add(String pname, int ptype, int nucByteLength, int ucByteLength, int decimals, String defaults, String description, int flags, Object tabMetaData, JCoExtendedFieldMetaData extended) {
            throw new UnsupportedOperationException("MetaData for a JCoRequest or a JCoResponse cannot be modified at all.");
        }

        public void add(String pname, int ptype, int nucByteLength, int ucByteLength, int decimals, String defaults, String description, int flags, Object tabMetaData, String tableFieldName, JCoExtendedFieldMetaData extended) {
            throw new UnsupportedOperationException("MetaData for a JCoRequest or a JCoResponse cannot be modified at all.");
        }

        public Object clone() {
            throw new UnsupportedOperationException();
        }

        public String getDefault(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getDefault(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getDefault(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getDefault(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isChanging(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isChanging(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isChanging(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isChanging(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isException(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isException(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isException(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isException(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isExport(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isExport(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isExport(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isExport(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isImport(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isImport(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isImport(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isImport(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isOptional(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isOptional(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isOptional(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isOptional(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getByteLength(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getByteLength(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getByteLength(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getByteLength(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getLength(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            switch (this.getType(index)) {
                case 5: 
                case 17: 
                case 29: 
                case 30: 
                case 99: {
                    return 0;
                }
            }
            return this.getByteLength(index);
        }

        public int getLength(String fieldName) {
            return this.getLength(this.indexOf(fieldName));
        }

        public String getClassNameOfField(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getClassNameOfField(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getClassNameOfField(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getClassNameOfField(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getDecimals(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getDecimals(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getDecimals(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getDecimals(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getDescription(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getDescription(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getDescription(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getDescription(AbstractRequestResponse.this.mapIndex[index]);
        }

        public JCoExtendedFieldMetaData getExtendedFieldMetaData(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getExtendedFieldMetaData(AbstractRequestResponse.this.mapIndex[index]);
        }

        public JCoExtendedFieldMetaData getExtendedFieldMetaData(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getExtendedFieldMetaData(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getFieldCount() {
            return AbstractRequestResponse.this.size;
        }

        public String getName() {
            return AbstractRequestResponse.this.name;
        }

        public String getName(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getName(AbstractRequestResponse.this.mapIndex[index]);
        }

        public JCoRecordMetaData getRecordMetaData(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getRecordMetaData(AbstractRequestResponse.this.mapIndex[index]);
        }

        public JCoRecordMetaData getRecordMetaData(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getRecordMetaData(AbstractRequestResponse.this.mapIndex[index]);
        }

        public JCoClassMetaData getClassMetaData(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getClassMetaData(AbstractRequestResponse.this.mapIndex[index]);
        }

        public JCoClassMetaData getClassMetaData(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getClassMetaData(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getRecordTypeName(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getRecordTypeName(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getRecordFieldName(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getRecordFieldName(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getRecordFieldName(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getRecordFieldName(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getRecordTypeName(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getRecordTypeName(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getType(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getType(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getType(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getType(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getTypeAsString(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getTypeAsString(AbstractRequestResponse.this.mapIndex[index]);
        }

        public String getTypeAsString(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getTypeAsString(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getUnicodeByteLength(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getUnicodeByteLength(AbstractRequestResponse.this.mapIndex[index]);
        }

        public int getUnicodeByteLength(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().getUnicodeByteLength(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean hasField(String fieldName) {
            try {
                AbstractRequestResponse.this.indexOf(fieldName);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public int indexOf(String fieldName) {
            return AbstractRequestResponse.this.indexOf(fieldName);
        }

        public boolean isLocked() {
            return true;
        }

        public boolean isNestedType1Structure(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isNestedType1Structure(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isNestedType1Structure(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isNestedType1Structure(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isStructure(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isStructure(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isStructure(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isStructure(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isTable(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isTable(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isTable(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isTable(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isAbapObject(String fieldName) {
            int index = this.indexOf(fieldName);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isAbapObject(AbstractRequestResponse.this.mapIndex[index]);
        }

        public boolean isAbapObject(int index) {
            AbstractRequestResponse.this.checkIndex(index);
            return AbstractRequestResponse.this.mapList[index].getListMetaData().isAbapObject(AbstractRequestResponse.this.mapIndex[index]);
        }

        public void lock() {
        }

        public int hashCode() {
            return AbstractRequestResponse.this.name.hashCode();
        }

        public boolean equals(Object obj) {
            int fieldCount = 0;
            if (obj == null || !(obj instanceof ResponseRequestMetadata)) {
                return false;
            }
            ResponseRequestMetadata m = (ResponseRequestMetadata)obj;
            fieldCount = this.getFieldCount();
            if (fieldCount != m.getFieldCount()) {
                return false;
            }
            for (int i = 0; i < fieldCount; ++i) {
                if (this.getType(i) != m.getType(i)) {
                    return false;
                }
                if (this.getUnicodeByteLength(i) != m.getUnicodeByteLength(i)) {
                    return false;
                }
                if (this.getByteLength(i) != m.getByteLength(i)) {
                    return false;
                }
                if (!this.getName(i).equals(m.getName(i))) {
                    return false;
                }
                if (this.getDecimals(i) != m.getDecimals(i)) {
                    return false;
                }
                if (!this.isStructure(i) && !this.isTable(i)) continue;
                String o1 = this.getRecordTypeName(i);
                String o2 = m.getRecordTypeName(i);
                if (!(o1 == null || o2 == null ? o1 != o2 : !o1.equals(o2))) continue;
                return false;
            }
            return true;
        }

        public void setName(String name) {
            throw new UnsupportedOperationException("MetaData for a JCoRequest or a JCoResponse cannot be modified at all.");
        }
    }
}

