/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.ext.JCoSessionReference;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.SessionTimeoutChecker;
import com.sap.conn.jco.rt.Trace;

public abstract class AbstractSessionManager {
    private SessionReferenceProvider sessionRefProvider = null;
    private SessionTimeoutChecker timeoutChecker = null;

    void setTimeoutChecker(SessionTimeoutChecker newTimeoutChecker) {
        this.timeoutChecker = newTimeoutChecker;
    }

    SessionTimeoutChecker getTimeoutChecker() {
        return this.timeoutChecker;
    }

    AbstractSessionManager() {
    }

    void updateSessionRefProvider(SessionReferenceProvider provider) {
        this.sessionRefProvider = provider;
    }

    SessionReferenceProvider getSessionReferenceProvider() {
        return this.sessionRefProvider;
    }

    protected abstract Context getRuntimeContext(String var1);

    protected abstract Context getRuntimeContext(String var1, boolean var2);

    protected abstract void releaseRuntimeContext(Context var1);

    abstract void startTimeoutChecker(JCoRuntime var1);

    private void trace(String api, InternalDestination d, String scopeType, String retValue) {
        if (Trace.isOn(32)) {
            String dID = "";
            if (d != null) {
                scopeType = d.getScopeType();
                dID = d.getDestinationID();
            }
            JCoSessionReference sessionReference = this.sessionRefProvider != null ? this.sessionRefProvider.getCurrentSessionReference(scopeType) : null;
            StringBuilder buf = new StringBuilder(150);
            buf.append("[JCoAPI] JCoContext.").append(api).append('(').append(dID);
            if (scopeType != null) {
                buf.append(") for scope ").append(scopeType);
            } else {
                buf.append(')');
            }
            if (sessionReference != null) {
                buf.append("in session ID ").append(sessionReference.getID());
            } else {
                buf.append("in invalid session");
            }
            if (retValue != null) {
                buf.append("returns ").append(retValue);
            }
            Trace.fireTrace(32, buf.toString());
        }
    }

    protected final void beginSequence(JCoDestination destination) {
        InternalDestination internalDestination = (InternalDestination)destination;
        String scopeType = internalDestination.getScopeType();
        this.trace("begin", internalDestination, scopeType, null);
        Context ctx = this.getRuntimeContext(scopeType);
        ctx.beginSequence(internalDestination);
    }

    protected final void endSequence(JCoDestination destination) throws JCoException {
        InternalDestination internalDestination = (InternalDestination)destination;
        String scopeType = internalDestination.getScopeType();
        this.trace("end", internalDestination, scopeType, null);
        Context ctx = this.getRuntimeContext(scopeType);
        ctx.endSequence(internalDestination);
    }

    protected boolean isStateful(JCoDestination destination) {
        boolean isStateful = false;
        InternalDestination internalDestination = (InternalDestination)destination;
        String scopeType = internalDestination == null ? null : internalDestination.getScopeType();
        Context ctx = this.getRuntimeContext(scopeType);
        isStateful = ctx.isInTx(internalDestination);
        this.trace("isStateful", internalDestination, scopeType, String.valueOf(isStateful));
        return isStateful;
    }
}

