/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoClassMetaData;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRequest;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import com.sap.conn.jco.monitor.JCoRepositoryMonitor;
import com.sap.conn.jco.rt.AbapFunctionTemplate;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DynamicRecordMetaData;
import com.sap.conn.jco.rt.MetaDataStorage;
import com.sap.conn.jco.rt.RepositoryProvider;
import com.sap.conn.jco.rt.TenantContext;
import com.sap.conn.jco.rt.json.RepReader;
import com.sap.conn.jco.rt.json.RepWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BasicRepository
implements JCoRepository,
RepositoryProvider {
    static final long serialVersionUID = 3000120080918L;
    protected String name;
    protected boolean containsUnicodeInfo = true;
    private MetaDataStorage storage = null;
    private BasicRepositoryMonitor monitor = null;
    long lastAccessTimestamp;
    TenantContext context;

    BasicRepository(TenantContext context, String name) {
        this.name = name;
        this.context = context;
        this.storage = new MetaDataStorage(this, name);
        this.lastAccessTimestamp = System.currentTimeMillis();
    }

    @Override
    public JCoRepository getRepository() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getMetaDataRelease() {
        return "000";
    }

    JCoFunctionTemplate addFunctionTemplate(JCoFunctionTemplate functionTemplate) {
        AbapFunctionTemplate removed;
        this.lastAccessTimestamp = System.currentTimeMillis();
        try {
            removed = this.storage.saveFunctionTemplate((AbapFunctionTemplate)functionTemplate);
        }
        catch (ClassCastException e) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only function templates created by JCo.createFunctionTemplate(...) can be saved in repository cache");
        }
        return removed;
    }

    DefaultRecordMetaData addRecordMetaData(JCoRecordMetaData recordMetaData) {
        DefaultRecordMetaData removed;
        this.lastAccessTimestamp = System.currentTimeMillis();
        recordMetaData.lock();
        try {
            removed = this.storage.saveRecordMetaData((DefaultRecordMetaData)recordMetaData);
        }
        catch (ClassCastException e) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only metadata created by JCo.createRecordMetaData(...) can be saved in repository cache");
        }
        return removed;
    }

    DefaultClassMetaData addClassMetaData(JCoClassMetaData classMetaData) {
        DefaultClassMetaData removed;
        this.lastAccessTimestamp = System.currentTimeMillis();
        classMetaData.lock();
        try {
            removed = this.storage.saveClassMetaData((DefaultClassMetaData)classMetaData);
        }
        catch (ClassCastException e) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only metadata created by JCo.createClassMetaData(...) can be saved in repository cache");
        }
        return removed;
    }

    public JCoFunctionTemplate getFunctionTemplate(String functionName) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (functionName == null) {
            throw new IllegalArgumentException("Provide a valid function name: null is not allowed");
        }
        return this.storage.loadFunctionTemplate(functionName);
    }

    public final JCoFunctionTemplate getFunctionTemplateFromCache(String functionName) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (functionName == null) {
            throw new IllegalArgumentException("Provide a valid function name: null is not allowed");
        }
        return this.storage.loadFunctionTemplateFromCache(functionName);
    }

    public JCoListMetaData getFunctionInterface(String functionName) throws JCoException {
        JCoFunctionTemplate template = this.getFunctionTemplate(functionName);
        return template != null ? template.getFunctionInterface() : null;
    }

    public JCoFunction getFunction(String functionName) throws JCoException {
        JCoFunctionTemplate template = this.getFunctionTemplate(functionName);
        return template != null ? template.getFunction() : null;
    }

    public JCoRequest getRequest(String functionName) throws JCoException {
        JCoFunctionTemplate template = this.getFunctionTemplate(functionName);
        return template != null ? template.getRequest() : null;
    }

    public DefaultRecordMetaData getRecordMetaData(String recordName) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (recordName == null) {
            throw new IllegalArgumentException("Provide a valid record name: null is not allowed");
        }
        return this.storage.loadRecordMetaData(recordName);
    }

    public final DefaultRecordMetaData getRecordMetaDataFromCache(String recordName) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (recordName == null) {
            throw new IllegalArgumentException("Provide a valid record name: null is not allowed");
        }
        return this.storage.loadRecordMetaDataFromCache(recordName);
    }

    public JCoRecordMetaData getStructureDefinition(String structureName) throws JCoException {
        return this.getRecordMetaData(structureName);
    }

    public DefaultClassMetaData getClassMetaData(String className) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (className == null) {
            throw new IllegalArgumentException("Provide a valid class name: null is not allowed");
        }
        return this.storage.loadClassMetaData(className);
    }

    public final DefaultClassMetaData getClassMetaDataFromCache(String className) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (className == null) {
            throw new IllegalArgumentException("Provide a valid class name: null is not allowed");
        }
        return this.storage.loadClassMetaDataFromCache(className);
    }

    void resolveDynamicRecordMetaData(DynamicRecordMetaData meta) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", "Unable to resolve dynamic meta data. Use a custom repository connected to an SAP Application Server ABAP to lookup meta data containing generic boxes instead.");
    }

    public void removeFunctionTemplateFromCache(String functionName) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (functionName == null) {
            throw new IllegalArgumentException("Provide a valid function name: null is not allowed");
        }
        this.storage.removeFunctionTemplate(functionName);
    }

    public void removeRecordMetaDataFromCache(String recordName) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (recordName == null) {
            throw new IllegalArgumentException("Provide a valid record name: null is not allowed");
        }
        this.storage.removeRecordMetaData(recordName);
    }

    public void removeClassMetaDataFromCache(String className) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (className == null) {
            throw new IllegalArgumentException("Provide a valid class name: null is not allowed");
        }
        this.storage.removeClassMetaData(className);
    }

    public void clear() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        this.storage.clear();
    }

    public String[] getCachedFunctionTemplateNames() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        Collection<String> names = this.storage.getCachedFunctionNames();
        return names.toArray(new String[names.size()]);
    }

    public String[] getCachedRecordMetaDataNames() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        Collection<String> names = this.storage.getCachedRecordNames();
        return names.toArray(new String[names.size()]);
    }

    public String[] getCachedClassMetaDataNames() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        Collection<String> names = this.storage.getCachedClassNames();
        return names.toArray(new String[names.size()]);
    }

    public boolean isUnicode() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        return this.containsUnicodeInfo;
    }

    protected boolean containsRecordMetaData(String typeName) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        return this.storage.containsRecord(typeName);
    }

    protected static boolean checkType1(DefaultRecordMetaData meta) {
        block4: for (int i = 0; i < meta.type.length; ++i) {
            switch (meta.type[i]) {
                case 17: {
                    if (meta.isNestedType1Structure(i)) continue block4;
                    DefaultRecordMetaData childMeta = (DefaultRecordMetaData)meta.getRecordMetaData(i);
                    if (childMeta.numOdata == 0 || BasicRepository.checkType1(childMeta)) continue block4;
                    return false;
                }
                case 29: 
                case 30: 
                case 99: {
                    return false;
                }
                default: {
                    continue block4;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRepositoryMonitor getMonitor() {
        BasicRepository basicRepository = this;
        synchronized (basicRepository) {
            if (this.monitor == null) {
                this.monitor = new BasicRepositoryMonitor();
            }
        }
        return this.monitor;
    }

    public void load(Reader reader) throws IOException {
        new RepReader(this).load(reader);
    }

    public void save(Writer writer) throws IOException {
        new RepWriter(this).write(writer);
    }

    class BasicRepositoryMonitor
    implements JCoRepositoryMonitor {
        BasicRepositoryMonitor() {
        }

        public long getLastAccessTimestamp() {
            return BasicRepository.this.lastAccessTimestamp;
        }

        public long getLastRemoteQueryTimestamp() {
            return 0L;
        }

        public int getFunctionMetaDataCount() {
            return BasicRepository.this.storage.getFunctionMetaDataCount();
        }

        public int getTypeMetaDataCount() {
            return BasicRepository.this.storage.getRecordMetaDataCount();
        }

        public int getClassMetaDataCount() {
            return BasicRepository.this.storage.getClassMetaDataCount();
        }

        public List<String> getDestinationIDs() {
            return new ArrayList<String>(0);
        }

        public JCoDestinationMonitor getRespositoryDestinationMonitor(String destinationID) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "The destination with ID " + destinationID + " is not used by this repository " + BasicRepository.this.getName());
        }

        public JCoRepository getRepository() {
            return BasicRepository.this;
        }
    }
}

